/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.ParquetDataOutput;
import com.facebook.presto.parquet.writer.PrimitiveColumnWriter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class PrimitiveColumnWriterV2
extends PrimitiveColumnWriter {
    private final RunLengthBitPackingHybridEncoder definitionLevelEncoder;
    private final RunLengthBitPackingHybridEncoder repetitionLevelEncoder;
    private int currentPageRowCount;

    public PrimitiveColumnWriterV2(Type type, ColumnDescriptor columnDescriptor, PrimitiveValueWriter primitiveValueWriter, RunLengthBitPackingHybridEncoder definitionLevelEncoder, RunLengthBitPackingHybridEncoder repetitionLevelEncoder, CompressionCodecName compressionCodecName, int pageSizeThreshold) {
        super(type, columnDescriptor, primitiveValueWriter, compressionCodecName, pageSizeThreshold);
        this.definitionLevelEncoder = Objects.requireNonNull(definitionLevelEncoder, "definitionLevelEncoder is null");
        this.repetitionLevelEncoder = Objects.requireNonNull(repetitionLevelEncoder, "repetitionLevelEncoder is null");
    }

    @Override
    protected void writeDefinitionAndRepetitionLevels(ColumnChunk current) throws IOException {
        Iterator<Integer> defIterator = DefinitionLevelIterables.getIterator(current.getDefinitionLevelIterables());
        while (defIterator.hasNext()) {
            int next = defIterator.next();
            this.definitionLevelEncoder.writeInt(next);
            if (next != this.maxDefinitionLevel) {
                ++this.currentPageNullCounts;
            }
            ++this.valueCount;
        }
        Iterator<Integer> repIterator = RepetitionLevelIterables.getIterator(current.getRepetitionLevelIterables());
        while (repIterator.hasNext()) {
            int next = repIterator.next();
            this.repetitionLevelEncoder.writeInt(next);
            if (next != 0) continue;
            ++this.currentPageRowCount;
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.of((Object)new ColumnWriter.BufferData(this.getDataStreams(), this.getColumnMetaData()));
    }

    @Override
    protected void flushCurrentPageToBuffer() throws IOException {
        long compressedSize;
        ParquetDataOutput data;
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        BytesInput bytes = this.primitiveValueWriter.getBytes();
        ParquetDataOutput repetitions = ParquetDataOutput.createDataOutput(BytesInput.copy((BytesInput)this.repetitionLevelEncoder.toBytes()));
        ParquetDataOutput definitions = ParquetDataOutput.createDataOutput(BytesInput.copy((BytesInput)this.definitionLevelEncoder.toBytes()));
        this.encodings.add(this.primitiveValueWriter.getEncoding());
        long uncompressedSize = bytes.size() + repetitions.size() + definitions.size();
        if (this.compressor != null) {
            data = this.compressor.compress(bytes);
            compressedSize = data.size() + repetitions.size() + definitions.size();
        } else {
            data = ParquetDataOutput.createDataOutput(BytesInput.copy((BytesInput)bytes));
            compressedSize = uncompressedSize;
        }
        ByteArrayOutputStream pageHeaderOutputStream = new ByteArrayOutputStream();
        Statistics<?> statistics = this.primitiveValueWriter.getStatistics();
        statistics.incrementNumNulls((long)this.currentPageNullCounts);
        this.columnStatistics.mergeStatistics(statistics);
        this.parquetMetadataConverter.writeDataPageV2Header((int)uncompressedSize, (int)compressedSize, this.valueCount, this.currentPageNullCounts, this.currentPageRowCount, statistics, this.primitiveValueWriter.getEncoding(), (int)repetitions.size(), (int)definitions.size(), (OutputStream)pageHeaderOutputStream);
        ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])pageHeaderOutputStream.toByteArray()));
        outputDataStreams.add((Object)pageHeader);
        outputDataStreams.add((Object)repetitions);
        outputDataStreams.add((Object)definitions);
        outputDataStreams.add((Object)data);
        ImmutableList dataOutputs = outputDataStreams.build();
        this.totalCompressedSize += pageHeader.size() + compressedSize;
        this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
        this.totalValues += (long)this.valueCount;
        this.pageBuffer.addAll(dataOutputs);
        this.valueCount = 0;
        this.currentPageNullCounts = 0;
        this.currentPageRowCount = 0;
        this.definitionLevelEncoder.reset();
        this.repetitionLevelEncoder.reset();
        this.primitiveValueWriter.reset();
    }

    @Override
    public long getBufferedBytes() {
        return this.pageBuffer.stream().mapToLong(ParquetDataOutput::size).sum() + this.definitionLevelEncoder.getBufferedSize() + this.repetitionLevelEncoder.getBufferedSize() + this.primitiveValueWriter.getBufferedSize();
    }
}

