/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.Preconditions;
import org.openjdk.jol.info.ClassLayout;

public class StructColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructColumnWriter.class).instanceSize();
    private final List<ColumnWriter> columnWriters;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public StructColumnWriter(List<ColumnWriter> columnWriters, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.columnWriters = Objects.requireNonNull(columnWriters, "columnWriters is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)columnChunk.getBlock());
        Preconditions.checkArgument((columnarRow.getFieldCount() == this.columnWriters.size() ? 1 : 0) != 0, (String)"ColumnarRow field size %s is not equal to columnWriters size %s", (Object)columnarRow.getFieldCount(), (Object)this.columnWriters.size());
        ImmutableList defLevelIterables = ImmutableList.builder().addAll(columnChunk.getDefinitionLevelIterables()).add((Object)DefinitionLevelIterables.of(columnarRow, this.maxDefinitionLevel)).build();
        ImmutableList repLevelIterables = ImmutableList.builder().addAll(columnChunk.getRepetitionLevelIterables()).add((Object)RepetitionLevelIterables.of(columnChunk.getBlock())).build();
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            ColumnWriter columnWriter = this.columnWriters.get(i);
            Block block = columnarRow.getField(i);
            columnWriter.writeBlock(new ColumnChunk(block, (List<DefinitionLevelIterable>)defLevelIterables, (List<RepetitionLevelIterable>)repLevelIterables));
        }
    }

    @Override
    public void close() {
        this.columnWriters.forEach(ColumnWriter::close);
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnWriter columnWriter : this.columnWriters) {
            builder.addAll(columnWriter.getBuffer());
        }
        return builder.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.columnWriters.stream().mapToLong(ColumnWriter::getBufferedBytes).sum();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.columnWriters.stream().mapToLong(ColumnWriter::getRetainedBytes).sum();
    }

    @Override
    public void reset() {
        this.columnWriters.forEach(ColumnWriter::reset);
    }
}

