/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.ParquetEncoding;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.openjdk.jol.info.ClassLayout;

public class DataPageV1
extends DataPage {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DataPageV1.class).instanceSize();
    private final Slice slice;
    private final Statistics<?> statistics;
    private final ParquetEncoding repetitionLevelEncoding;
    private final ParquetEncoding definitionLevelEncoding;
    private final ParquetEncoding valuesEncoding;

    public DataPageV1(Slice slice, int valueCount, int uncompressedSize, long firstRowIndex, Statistics<?> statistics, ParquetEncoding repetitionLevelEncoding, ParquetEncoding definitionLevelEncoding, ParquetEncoding valuesEncoding) {
        super(slice.length(), uncompressedSize, valueCount, firstRowIndex);
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.statistics = statistics;
        this.repetitionLevelEncoding = repetitionLevelEncoding;
        this.definitionLevelEncoding = definitionLevelEncoding;
        this.valuesEncoding = valuesEncoding;
    }

    @Override
    public Slice getSlice() {
        return this.slice;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize();
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }

    public ParquetEncoding getDefinitionLevelEncoding() {
        return this.definitionLevelEncoding;
    }

    public ParquetEncoding getRepetitionLevelEncoding() {
        return this.repetitionLevelEncoding;
    }

    public ParquetEncoding getValueEncoding() {
        return this.valuesEncoding;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("statistics", this.statistics).add("repetitionLevelEncoding", (Object)this.repetitionLevelEncoding).add("definitionLevelEncoding", (Object)this.definitionLevelEncoding).add("valuesEncoding", (Object)this.valuesEncoding).add("valueCount", this.valueCount).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).add("firstRowIndex", this.getFirstRowIndex()).toString();
    }
}

