/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.ParquetErrorCode;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.decoders.DefinitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.FlatDefinitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.RepetitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.delta.BinaryDeltaValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.delta.Int32DeltaBinaryPackedValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.delta.Int64DeltaBinaryPackedValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.delta.Int64TimestampMicrosDeltaBinaryPackedValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BinaryPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BooleanPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.Int32PlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.Int64PlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.Int64TimestampMicrosPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.TimestampPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BinaryRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BooleanRLEValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.Int32RLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.Int64RLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.Int64TimestampMicrosRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.TimestampRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.BinaryBatchDictionary;
import com.facebook.presto.parquet.batchreader.dictionary.TimestampDictionary;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.dictionary.IntegerDictionary;
import com.facebook.presto.parquet.dictionary.LongDictionary;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.PrimitiveType;

public class Decoders {
    private Decoders() {
    }

    public static FlatDecoders readFlatPage(DataPage page, RichColumnDescriptor columnDescriptor, Dictionary dictionary) {
        try {
            if (page instanceof DataPageV1) {
                return Decoders.readFlatPageV1((DataPageV1)page, columnDescriptor, dictionary);
            }
            return Decoders.readFlatPageV2((DataPageV2)page, columnDescriptor, dictionary);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_IO_READ_ERROR, "Error reading parquet page " + page + " in column " + (Object)((Object)columnDescriptor), (Throwable)e);
        }
    }

    private static final ValuesDecoder createValuesDecoder(ColumnDescriptor columnDescriptor, Dictionary dictionary, int valueCount, ParquetEncoding encoding, byte[] buffer, int offset, int length) throws IOException {
        PrimitiveType.PrimitiveTypeName type = columnDescriptor.getPrimitiveType().getPrimitiveTypeName();
        if (encoding == ParquetEncoding.PLAIN) {
            switch (type) {
                case BOOLEAN: {
                    return new BooleanPlainValuesDecoder(buffer, offset, length);
                }
                case INT32: 
                case FLOAT: {
                    return new Int32PlainValuesDecoder(buffer, offset, length);
                }
                case INT64: {
                    if (ParquetTypeUtils.isTimeStampMicrosType(columnDescriptor)) {
                        return new Int64TimestampMicrosPlainValuesDecoder(buffer, offset, length);
                    }
                }
                case DOUBLE: {
                    return new Int64PlainValuesDecoder(buffer, offset, length);
                }
                case INT96: {
                    return new TimestampPlainValuesDecoder(buffer, offset, length);
                }
                case BINARY: {
                    return new BinaryPlainValuesDecoder(buffer, offset, length);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_UNSUPPORTED_COLUMN_TYPE, String.format("Column: %s, Encoding: %s", new Object[]{columnDescriptor, encoding}));
        }
        if (encoding == ParquetEncoding.RLE && type == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, offset, length);
            byteBuffer.getInt();
            return new BooleanRLEValuesDecoder(byteBuffer);
        }
        if (encoding == ParquetEncoding.RLE_DICTIONARY || encoding == ParquetEncoding.PLAIN_DICTIONARY) {
            ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, offset, length)});
            int bitWidth = BytesUtils.readIntLittleEndianOnOneByte((InputStream)inputStream);
            switch (type) {
                case INT32: 
                case FLOAT: {
                    return new Int32RLEDictionaryValuesDecoder(bitWidth, (InputStream)inputStream, (IntegerDictionary)dictionary);
                }
                case INT64: {
                    if (ParquetTypeUtils.isTimeStampMicrosType(columnDescriptor)) {
                        return new Int64TimestampMicrosRLEDictionaryValuesDecoder(bitWidth, (InputStream)inputStream, (LongDictionary)dictionary);
                    }
                }
                case DOUBLE: {
                    return new Int64RLEDictionaryValuesDecoder(bitWidth, (InputStream)inputStream, (LongDictionary)dictionary);
                }
                case INT96: {
                    return new TimestampRLEDictionaryValuesDecoder(bitWidth, (InputStream)inputStream, (TimestampDictionary)dictionary);
                }
                case BINARY: {
                    return new BinaryRLEDictionaryValuesDecoder(bitWidth, (InputStream)inputStream, (BinaryBatchDictionary)dictionary);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_UNSUPPORTED_COLUMN_TYPE, String.format("Column: %s, Encoding: %s", new Object[]{columnDescriptor, encoding}));
        }
        if (encoding == ParquetEncoding.DELTA_BINARY_PACKED) {
            ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, offset, length)});
            switch (type) {
                case INT32: 
                case FLOAT: {
                    return new Int32DeltaBinaryPackedValuesDecoder(valueCount, inputStream);
                }
                case INT64: {
                    if (ParquetTypeUtils.isTimeStampMicrosType(columnDescriptor)) {
                        return new Int64TimestampMicrosDeltaBinaryPackedValuesDecoder(valueCount, inputStream);
                    }
                }
                case DOUBLE: {
                    return new Int64DeltaBinaryPackedValuesDecoder(valueCount, inputStream);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_UNSUPPORTED_COLUMN_TYPE, String.format("Column: %s, Encoding: %s", new Object[]{columnDescriptor, encoding}));
        }
        if ((encoding == ParquetEncoding.DELTA_BYTE_ARRAY || encoding == ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY) && type == PrimitiveType.PrimitiveTypeName.BINARY) {
            ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, offset, length)});
            return new BinaryDeltaValuesDecoder(encoding, valueCount, inputStream);
        }
        throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_UNSUPPORTED_ENCODING, String.format("Column: %s, Encoding: %s", new Object[]{columnDescriptor, encoding}));
    }

    private static FlatDecoders readFlatPageV1(DataPageV1 page, RichColumnDescriptor columnDescriptor, Dictionary dictionary) throws IOException {
        byte[] bytes = page.getSlice().getBytes();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, bytes.length);
        FlatDefinitionLevelDecoder definitionLevelDecoder = Decoders.createFlatDefinitionLevelDecoder(page.getDefinitionLevelEncoding(), columnDescriptor.isRequired(), columnDescriptor.getMaxDefinitionLevel(), page.getValueCount(), byteBuffer);
        ValuesDecoder valuesDecoder = Decoders.createValuesDecoder(columnDescriptor, dictionary, page.getValueCount(), page.getValueEncoding(), bytes, byteBuffer.position(), bytes.length - byteBuffer.position());
        return new FlatDecoders(definitionLevelDecoder, valuesDecoder);
    }

    private static FlatDecoders readFlatPageV2(DataPageV2 pageV2, RichColumnDescriptor columnDescriptor, Dictionary dictionary) throws IOException {
        int valueCount = pageV2.getValueCount();
        int maxDefinitionLevel = columnDescriptor.getMaxDefinitionLevel();
        Preconditions.checkArgument((maxDefinitionLevel <= 1 && maxDefinitionLevel >= 0 ? 1 : 0) != 0, (Object)("Invalid max definition level: " + maxDefinitionLevel));
        FlatDefinitionLevelDecoder definitionLevelDecoder = maxDefinitionLevel == 0 ? new FlatDefinitionLevelDecoder(0, valueCount) : new FlatDefinitionLevelDecoder(valueCount, new ByteArrayInputStream(pageV2.getDefinitionLevels().getBytes()));
        ValuesDecoder valuesDecoder = Decoders.createValuesDecoderV2(pageV2, columnDescriptor, dictionary);
        return new FlatDecoders(definitionLevelDecoder, valuesDecoder);
    }

    public static NestedDecoders readNestedPage(DataPage page, RichColumnDescriptor columnDescriptor, Dictionary dictionary) {
        try {
            if (page instanceof DataPageV1) {
                return Decoders.readNestedPageV1((DataPageV1)page, columnDescriptor, dictionary);
            }
            return Decoders.readNestedPageV2((DataPageV2)page, columnDescriptor, dictionary);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_IO_READ_ERROR, "Error reading parquet page " + page + " in column " + (Object)((Object)columnDescriptor), (Throwable)e);
        }
    }

    private static NestedDecoders readNestedPageV1(DataPageV1 page, RichColumnDescriptor columnDescriptor, Dictionary dictionary) throws IOException {
        byte[] bytes = page.getSlice().getBytes();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, bytes.length);
        RepetitionLevelDecoder repetitionLevelDecoder = Decoders.createRepetitionLevelDecoder(page.getRepetitionLevelEncoding(), columnDescriptor.getMaxRepetitionLevel(), page.getValueCount(), byteBuffer);
        DefinitionLevelDecoder definitionLevelDecoder = Decoders.createDefinitionLevelDecoder(page.getDefinitionLevelEncoding(), columnDescriptor.getMaxDefinitionLevel(), page.getValueCount(), byteBuffer);
        ValuesDecoder valuesDecoder = Decoders.createValuesDecoder(columnDescriptor, dictionary, page.getValueCount(), page.getValueEncoding(), bytes, byteBuffer.position(), bytes.length - byteBuffer.position());
        return new NestedDecoders(repetitionLevelDecoder, definitionLevelDecoder, valuesDecoder);
    }

    private static NestedDecoders readNestedPageV2(DataPageV2 pageV2, RichColumnDescriptor columnDescriptor, Dictionary dictionary) throws IOException {
        int valueCount = pageV2.getValueCount();
        return new NestedDecoders(Decoders.createRepetitionLevelDecoderV2(valueCount, columnDescriptor, pageV2.getRepetitionLevels()), Decoders.createDefinitionLevelDecoderV2(valueCount, columnDescriptor, pageV2.getDefinitionLevels()), Decoders.createValuesDecoderV2(pageV2, columnDescriptor, dictionary));
    }

    private static final RepetitionLevelDecoder createRepetitionLevelDecoderV2(int valueCount, RichColumnDescriptor columnDescriptor, Slice repetitionLevelBuffer) {
        int maxRepetitionLevel = columnDescriptor.getMaxRepetitionLevel();
        int repetitionLevelBitWidth = BytesUtils.getWidthFromMaxInt((int)maxRepetitionLevel);
        if (maxRepetitionLevel == 0 || repetitionLevelBitWidth == 0) {
            return new RepetitionLevelDecoder(0, valueCount);
        }
        return new RepetitionLevelDecoder(valueCount, repetitionLevelBitWidth, new ByteArrayInputStream(repetitionLevelBuffer.getBytes()));
    }

    private static final DefinitionLevelDecoder createDefinitionLevelDecoderV2(int valueCount, RichColumnDescriptor columnDescriptor, Slice definitionLevelBuffer) {
        int maxDefinitionLevel = columnDescriptor.getMaxDefinitionLevel();
        int definitionLevelBitWidth = BytesUtils.getWidthFromMaxInt((int)maxDefinitionLevel);
        if (maxDefinitionLevel == 0 || definitionLevelBitWidth == 0) {
            return new DefinitionLevelDecoder(0, valueCount);
        }
        return new DefinitionLevelDecoder(valueCount, definitionLevelBitWidth, new ByteArrayInputStream(definitionLevelBuffer.getBytes()));
    }

    private static final ValuesDecoder createValuesDecoderV2(DataPageV2 pageV2, RichColumnDescriptor columnDescriptor, Dictionary dictionary) throws IOException {
        byte[] valueBuffer = pageV2.getSlice().getBytes();
        return Decoders.createValuesDecoder(columnDescriptor, dictionary, pageV2.getValueCount(), pageV2.getDataEncoding(), valueBuffer, 0, valueBuffer.length);
    }

    private static final FlatDefinitionLevelDecoder createFlatDefinitionLevelDecoder(ParquetEncoding encoding, boolean isRequired, int maxLevelValue, int valueCount, ByteBuffer buffer) throws IOException {
        if (isRequired) {
            return new FlatDefinitionLevelDecoder(1, valueCount);
        }
        if (maxLevelValue == 0) {
            return new FlatDefinitionLevelDecoder(0, valueCount);
        }
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)maxLevelValue);
        if (bitWidth == 0) {
            return new FlatDefinitionLevelDecoder(0, valueCount);
        }
        Preconditions.checkArgument((encoding == ParquetEncoding.RLE ? 1 : 0) != 0, (Object)("Invalid definition level encoding: " + (Object)((Object)encoding)));
        ByteBufferInputStream bufferInputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
        int bufferSize = BytesUtils.readIntLittleEndian((InputStream)bufferInputStream);
        FlatDefinitionLevelDecoder definitionLevelDecoder = new FlatDefinitionLevelDecoder(valueCount, (InputStream)bufferInputStream.sliceStream((long)bufferSize));
        ((Buffer)buffer).position(buffer.position() + bufferSize + 4);
        return definitionLevelDecoder;
    }

    public static final RepetitionLevelDecoder createRepetitionLevelDecoder(ParquetEncoding encoding, int maxLevelValue, int valueCount, ByteBuffer buffer) throws IOException {
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)maxLevelValue);
        if (maxLevelValue == 0 || bitWidth == 0) {
            return new RepetitionLevelDecoder(0, valueCount);
        }
        Preconditions.checkArgument((encoding == ParquetEncoding.RLE ? 1 : 0) != 0, (Object)("Invalid repetition level encoding: " + (Object)((Object)encoding)));
        ByteBufferInputStream bufferInputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
        int bufferSize = BytesUtils.readIntLittleEndian((InputStream)bufferInputStream);
        RepetitionLevelDecoder repetitionLevelDecoder = new RepetitionLevelDecoder(valueCount, bitWidth, (InputStream)bufferInputStream.sliceStream((long)bufferSize));
        ((Buffer)buffer).position(buffer.position() + bufferSize + 4);
        return repetitionLevelDecoder;
    }

    public static final DefinitionLevelDecoder createDefinitionLevelDecoder(ParquetEncoding encoding, int maxLevelValue, int valueCount, ByteBuffer buffer) throws IOException {
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)maxLevelValue);
        if (maxLevelValue == 0 || bitWidth == 0) {
            return new DefinitionLevelDecoder(0, valueCount);
        }
        Preconditions.checkArgument((encoding == ParquetEncoding.RLE ? 1 : 0) != 0, (Object)("Invalid definition level encoding: " + (Object)((Object)encoding)));
        ByteBufferInputStream bufferInputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{buffer});
        int bufferSize = BytesUtils.readIntLittleEndian((InputStream)bufferInputStream);
        DefinitionLevelDecoder definitionLevelDecoder = new DefinitionLevelDecoder(valueCount, bitWidth, (InputStream)bufferInputStream.sliceStream((long)bufferSize));
        ((Buffer)buffer).position(buffer.position() + bufferSize + 4);
        return definitionLevelDecoder;
    }

    public static class NestedDecoders {
        private final RepetitionLevelDecoder repetitionLevelDecoder;
        private final DefinitionLevelDecoder definitionLevelDecoder;
        private final ValuesDecoder valuesDecoder;

        private NestedDecoders(RepetitionLevelDecoder repetitionLevelDecoder, DefinitionLevelDecoder definitionLevelDecoder, ValuesDecoder valuesDecoder) {
            this.repetitionLevelDecoder = repetitionLevelDecoder;
            this.definitionLevelDecoder = definitionLevelDecoder;
            this.valuesDecoder = valuesDecoder;
        }

        public RepetitionLevelDecoder getRepetitionLevelDecoder() {
            return this.repetitionLevelDecoder;
        }

        public DefinitionLevelDecoder getDefinitionLevelDecoder() {
            return this.definitionLevelDecoder;
        }

        public ValuesDecoder getValuesDecoder() {
            return this.valuesDecoder;
        }
    }

    public static class FlatDecoders {
        private final FlatDefinitionLevelDecoder definitionLevelDecoder;
        private final ValuesDecoder valuesDecoder;

        private FlatDecoders(FlatDefinitionLevelDecoder dlDecoder, ValuesDecoder valuesDecoder) {
            this.definitionLevelDecoder = dlDecoder;
            this.valuesDecoder = valuesDecoder;
        }

        public FlatDefinitionLevelDecoder getDefinitionLevelDecoder() {
            return this.definitionLevelDecoder;
        }

        public ValuesDecoder getValuesDecoder() {
            return this.valuesDecoder;
        }
    }
}

