/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.parquet.batchreader.BytesUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.ParquetDecodingException;
import org.openjdk.jol.info.ClassLayout;

public class BooleanRLEValuesDecoder
implements ValuesDecoder.BooleanValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BooleanRLEValuesDecoder.class).instanceSize();
    private final ByteBuffer inputBuffer;
    private MODE mode;
    private int currentCount;
    private byte currentValue;
    private int currentByteOffset;
    private byte currentByte;

    public BooleanRLEValuesDecoder(ByteBuffer inputBuffer) {
        this.inputBuffer = Objects.requireNonNull(inputBuffer);
    }

    public static int readUnsignedVarInt(ByteBuffer in) {
        int value = 0;
        byte b = in.get();
        int i = 0;
        while ((b & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            b = in.get();
            i += 7;
        }
        return value | b << i;
    }

    @Override
    public void readNext(byte[] values, int offset, int length) {
        int numEntriesToFill;
        int destinationIndex = offset;
        for (int remainingToCopy = length; remainingToCopy > 0; remainingToCopy -= numEntriesToFill) {
            if (this.currentCount == 0) {
                this.readNext();
                if (this.currentCount == 0) break;
            }
            numEntriesToFill = Math.min(remainingToCopy, this.currentCount);
            int endIndex = destinationIndex + numEntriesToFill;
            switch (this.mode) {
                case RLE: {
                    byte rleValue = this.currentValue;
                    while (destinationIndex < endIndex) {
                        values[destinationIndex] = rleValue;
                        ++destinationIndex;
                    }
                    break;
                }
                case PACKED: {
                    int i;
                    byte inValue;
                    int remainingPackedBlock = numEntriesToFill;
                    if (this.currentByteOffset > 0) {
                        int readChunk = Math.min(remainingPackedBlock, 8 - this.currentByteOffset);
                        inValue = this.currentByte;
                        for (i = 0; i < readChunk; ++i) {
                            values[destinationIndex++] = (byte)(inValue >> this.currentByteOffset & 1);
                            ++this.currentByteOffset;
                        }
                        remainingPackedBlock -= readChunk;
                        this.currentByteOffset %= 8;
                    }
                    ByteBuffer localInputBuffer = this.inputBuffer;
                    while (remainingPackedBlock >= 8) {
                        BytesUtils.unpack8Values(localInputBuffer.get(), values, destinationIndex);
                        remainingPackedBlock -= 8;
                        destinationIndex += 8;
                    }
                    if (remainingPackedBlock <= 0) break;
                    inValue = localInputBuffer.get();
                    for (i = 0; i < remainingPackedBlock; ++i) {
                        values[destinationIndex++] = (byte)(inValue >> i & 1);
                    }
                    this.currentByte = inValue;
                    this.currentByteOffset = remainingPackedBlock;
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= numEntriesToFill;
        }
    }

    @Override
    public void skip(int length) {
        int remainingToSkip;
        int numEntriesToSkip;
        for (remainingToSkip = length; remainingToSkip > 0; remainingToSkip -= numEntriesToSkip) {
            if (this.currentCount == 0) {
                this.readNext();
                if (this.currentCount == 0) break;
            }
            numEntriesToSkip = Math.min(remainingToSkip, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    break;
                }
                case PACKED: {
                    int fullBytes;
                    int remainingPackedBlock = numEntriesToSkip;
                    if (this.currentByteOffset > 0) {
                        int skipChunk = Math.min(remainingPackedBlock, 8 - this.currentByteOffset);
                        this.currentByteOffset += skipChunk;
                        remainingPackedBlock -= skipChunk;
                        this.currentByteOffset %= 8;
                    }
                    if ((fullBytes = remainingPackedBlock / 8) > 0) {
                        ((Buffer)this.inputBuffer).position(this.inputBuffer.position() + fullBytes);
                    }
                    if ((remainingPackedBlock %= 8) <= 0) break;
                    this.currentByte = this.inputBuffer.get();
                    this.currentByteOffset = remainingPackedBlock;
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= numEntriesToSkip;
        }
        com.google.common.base.Preconditions.checkState((remainingToSkip == 0 ? 1 : 0) != 0, (Object)"Invalid read size request");
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + this.inputBuffer.array().length;
    }

    private void readNext() {
        Preconditions.checkArgument((boolean)this.inputBuffer.hasRemaining(), (String)"Reading past RLE/BitPacking stream.");
        int header = BooleanRLEValuesDecoder.readUnsignedVarInt(this.inputBuffer);
        this.mode = (header & 1) == 0 ? MODE.RLE : MODE.PACKED;
        switch (this.mode) {
            case RLE: {
                this.currentCount = header >>> 1;
                this.currentValue = this.inputBuffer.get();
                return;
            }
            case PACKED: {
                int numGroups = header >>> 1;
                this.currentCount = numGroups * 8;
                this.currentByteOffset = 0;
                return;
            }
        }
        throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
    }

    private static enum MODE {
        RLE,
        PACKED;

    }
}

