/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.cache;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;

public class ParquetCacheConfig {
    private boolean metadataCacheEnabled;
    private DataSize metadataCacheSize = new DataSize(0.0, DataSize.Unit.BYTE);
    private Duration metadataCacheTtlSinceLastAccess = new Duration(0.0, TimeUnit.SECONDS);

    public boolean isMetadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    @Config(value="parquet.metadata-cache-enabled")
    @ConfigDescription(value="Enable cache for parquet metadata")
    public ParquetCacheConfig setMetadataCacheEnabled(boolean metadataCacheEnabled) {
        this.metadataCacheEnabled = metadataCacheEnabled;
        return this;
    }

    @MinDataSize(value="0B")
    public DataSize getMetadataCacheSize() {
        return this.metadataCacheSize;
    }

    @Config(value="parquet.metadata-cache-size")
    @ConfigDescription(value="Size of the parquet metadata cache")
    public ParquetCacheConfig setMetadataCacheSize(DataSize metadataCacheSize) {
        this.metadataCacheSize = metadataCacheSize;
        return this;
    }

    @MinDuration(value="0s")
    public Duration getMetadataCacheTtlSinceLastAccess() {
        return this.metadataCacheTtlSinceLastAccess;
    }

    @Config(value="parquet.metadata-cache-ttl-since-last-access")
    @ConfigDescription(value="Time-to-live for parquet metadata cache entry after last access")
    public ParquetCacheConfig setMetadataCacheTtlSinceLastAccess(Duration metadataCacheTtlSinceLastAccess) {
        this.metadataCacheTtlSinceLastAccess = metadataCacheTtlSinceLastAccess;
        return this;
    }
}

