/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.io.IOException;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.io.api.Binary;
import org.openjdk.jol.info.ClassLayout;

public class BinaryDictionary
extends Dictionary {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryDictionary.class).instanceSize();
    private final Binary[] content;

    public BinaryDictionary(DictionaryPage dictionaryPage) throws IOException {
        this(dictionaryPage, null);
    }

    public BinaryDictionary(DictionaryPage dictionaryPage, Integer length) throws IOException {
        super(dictionaryPage.getEncoding());
        int offset;
        byte[] dictionaryBytes;
        this.content = new Binary[dictionaryPage.getDictionarySize()];
        Slice dictionarySlice = dictionaryPage.getSlice();
        if (dictionarySlice.hasByteArray()) {
            dictionaryBytes = dictionarySlice.byteArray();
            offset = dictionarySlice.byteArrayOffset();
        } else {
            dictionaryBytes = dictionarySlice.getBytes();
            offset = 0;
        }
        if (length == null) {
            for (int i = 0; i < this.content.length; ++i) {
                int len = BytesUtils.readIntLittleEndian((byte[])dictionaryBytes, (int)offset);
                this.content[i] = Binary.fromByteArray((byte[])dictionaryBytes, (int)(offset += 4), (int)len);
                offset += len;
            }
        } else {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (String)"Invalid byte array length: %s", (Object)length);
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = Binary.fromByteArray((byte[])dictionaryBytes, (int)offset, (int)length);
                offset += length.intValue();
            }
        }
    }

    @Override
    public Binary decodeToBinary(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.content);
    }
}

