/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.plain.PlainValuesReader;
import org.openjdk.jol.info.ClassLayout;

public class LongDictionary
extends Dictionary {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDictionary.class).instanceSize();
    private final long[] content;

    public LongDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new long[dictionaryPage.getDictionarySize()];
        PlainValuesReader.LongPlainValuesReader longReader = new PlainValuesReader.LongPlainValuesReader();
        ByteBufferInputStream inputStream = ByteBufferInputStream.wrap((List)ImmutableList.of((Object)dictionaryPage.getSlice().toByteBuffer()));
        longReader.initFromPage(dictionaryPage.getDictionarySize(), inputStream);
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = longReader.readLong();
        }
    }

    @Override
    public long decodeToLong(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((long[])this.content);
    }
}

