/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.AbstractColumnReader;

public class IntColumnReader
extends AbstractColumnReader {
    public IntColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (type instanceof BigintType) {
                type.writeLong(blockBuilder, Integer.valueOf(this.valuesReader.readInteger()).longValue());
                return;
            }
            if (type instanceof RealType) {
                type.writeLong(blockBuilder, (long)Float.floatToIntBits(Integer.valueOf(this.valuesReader.readInteger()).floatValue()));
                return;
            }
            if (type instanceof DoubleType) {
                type.writeDouble(blockBuilder, Integer.valueOf(this.valuesReader.readInteger()).doubleValue());
                return;
            }
            type.writeLong(blockBuilder, (long)this.valuesReader.readInteger());
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readInteger();
        }
    }
}

