/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetTypeUtils;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntList;

public class ListColumnReader {
    private ListColumnReader() {
    }

    public static void calculateCollectionOffsets(Field field, IntList offsets, BooleanList collectionIsNull, int[] definitionLevels, int[] repetitionLevels) {
        int maxDefinitionLevel = field.getDefinitionLevel();
        int maxElementRepetitionLevel = field.getRepetitionLevel() + 1;
        boolean required = field.isRequired();
        int offset = 0;
        offsets.add(offset);
        int i = 0;
        while (i < definitionLevels.length) {
            if (ParquetTypeUtils.isValueNull(required, definitionLevels[i], maxDefinitionLevel)) {
                collectionIsNull.add(true);
                offsets.add(offset);
            } else if (definitionLevels[i] == maxDefinitionLevel) {
                collectionIsNull.add(false);
                offsets.add(offset);
            } else if (definitionLevels[i] > maxDefinitionLevel) {
                collectionIsNull.add(false);
                offsets.add(offset += ListColumnReader.getCollectionSize(repetitionLevels, maxElementRepetitionLevel, i + 1));
            }
            i = ListColumnReader.getNextCollectionStartIndex(repetitionLevels, maxElementRepetitionLevel, i);
        }
    }

    private static int getNextCollectionStartIndex(int[] repetitionLevels, int maxRepetitionLevel, int elementIndex) {
        while (ListColumnReader.hasMoreElements(repetitionLevels, ++elementIndex) && !ListColumnReader.isCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, elementIndex)) {
        }
        return elementIndex;
    }

    private static int getCollectionSize(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        int size = 1;
        while (ListColumnReader.hasMoreElements(repetitionLevels, nextIndex) && !ListColumnReader.isCollectionBeginningMarker(repetitionLevels, maxRepetitionLevel, nextIndex)) {
            if (repetitionLevels[nextIndex] <= maxRepetitionLevel) {
                ++size;
            }
            ++nextIndex;
        }
        return size;
    }

    private static boolean isCollectionBeginningMarker(int[] repetitionLevels, int maxRepetitionLevel, int nextIndex) {
        return repetitionLevels[nextIndex] < maxRepetitionLevel;
    }

    private static boolean hasMoreElements(int[] repetitionLevels, int nextIndex) {
        return nextIndex < repetitionLevels.length;
    }
}

