/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import io.airlift.units.DataSize;
import java.util.Objects;
import org.apache.parquet.column.ParquetProperties;

public class ParquetWriterOptions {
    private static final DataSize DEFAULT_MAX_ROW_GROUP_SIZE = DataSize.valueOf((String)"128MB");
    private static final DataSize DEFAULT_MAX_PAGE_SIZE = DataSize.valueOf((String)"1MB");
    public static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.WriterVersion.PARQUET_2_0;
    private final int maxRowGroupSize;
    private final int maxPageSize;
    private final int maxDictionaryPageSize;
    private final ParquetProperties.WriterVersion writerVersion;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(DataSize maxRowGroupSize, DataSize maxPageSize, DataSize maxDictionaryPageSize, ParquetProperties.WriterVersion writerVersion) {
        this.maxRowGroupSize = Math.toIntExact(Objects.requireNonNull(maxRowGroupSize, "maxRowGroupSize is null").toBytes());
        this.maxPageSize = Math.toIntExact(Objects.requireNonNull(maxPageSize, "maxPageSize is null").toBytes());
        this.maxDictionaryPageSize = Math.toIntExact(Objects.requireNonNull(maxDictionaryPageSize, "maxDictionaryPageSize is null").toBytes());
        this.writerVersion = Objects.requireNonNull(writerVersion, "writerVersion is null");
    }

    public int getMaxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getMaxDictionaryPageSize() {
        return this.maxDictionaryPageSize;
    }

    public ParquetProperties.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    static /* synthetic */ DataSize access$000() {
        return DEFAULT_MAX_ROW_GROUP_SIZE;
    }

    static /* synthetic */ DataSize access$100() {
        return DEFAULT_MAX_PAGE_SIZE;
    }

    public static class Builder {
        private DataSize maxBlockSize = ParquetWriterOptions.access$000();
        private DataSize maxPageSize = ParquetWriterOptions.access$100();
        private DataSize maxDictionaryPageSize = ParquetWriterOptions.access$100();
        private ParquetProperties.WriterVersion writerVersion = DEFAULT_WRITER_VERSION;

        public Builder setMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public Builder setMaxPageSize(DataSize maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public Builder setMaxDictionaryPageSize(DataSize maxDictionaryPageSize) {
            this.maxDictionaryPageSize = maxDictionaryPageSize;
            return this;
        }

        public Builder setWriterVersion(ParquetProperties.WriterVersion writerVersion) {
            this.writerVersion = writerVersion;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this.maxBlockSize, this.maxPageSize, this.maxDictionaryPageSize, this.writerVersion);
        }
    }
}

