/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public final class ParquetCryptoMetaDataUtils {
    private ParquetCryptoMetaDataUtils() {
    }

    public static MessageType removeColumnsInSchema(MessageType schema, Set<ColumnPath> paths) {
        ArrayList<String> currentPath = new ArrayList<String>();
        List<Type> prunedFields = ParquetCryptoMetaDataUtils.removeColumnsInFields(schema.getFields(), currentPath, paths);
        return new MessageType(schema.getName(), prunedFields);
    }

    private static List<Type> removeColumnsInFields(List<Type> fields, List<String> currentPath, Set<ColumnPath> paths) {
        ArrayList<Type> prunedFields = new ArrayList<Type>();
        for (Type childField : fields) {
            Type prunedChildField = ParquetCryptoMetaDataUtils.removeColumnsInField(childField, currentPath, paths);
            if (prunedChildField == null) continue;
            prunedFields.add(prunedChildField);
        }
        return prunedFields;
    }

    private static Type removeColumnsInField(Type field, List<String> currentPath, Set<ColumnPath> paths) {
        String fieldName = field.getName();
        currentPath.add(fieldName);
        ColumnPath path = ColumnPath.get((String[])currentPath.toArray(new String[0]));
        Type prunedField = null;
        if (!paths.contains(path)) {
            if (field.isPrimitive()) {
                prunedField = field;
            } else {
                List childFields = ((GroupType)field).getFields();
                List<Type> prunedFields = ParquetCryptoMetaDataUtils.removeColumnsInFields(childFields, currentPath, paths);
                if (prunedFields.size() > 0) {
                    prunedField = ((GroupType)field).withNewFields(prunedFields);
                }
            }
        }
        Preconditions.checkState((currentPath.size() > 0 ? 1 : 0) != 0, (Object)"The length of currentPath is empty but trying to remove element in it");
        Preconditions.checkState((currentPath.get(currentPath.size() - 1) != null ? 1 : 0) != 0, (Object)"The last element of currentPath is null");
        Preconditions.checkState((boolean)currentPath.get(currentPath.size() - 1).equals(fieldName), (Object)("The last element of currentPath " + currentPath.get(currentPath.size() - 1) + " not equal to " + fieldName));
        currentPath.remove(currentPath.size() - 1);
        return prunedField;
    }
}

