/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.BinaryFlatBatchReader;
import com.facebook.presto.parquet.batchreader.BinaryNestedBatchReader;
import com.facebook.presto.parquet.batchreader.BooleanFlatBatchReader;
import com.facebook.presto.parquet.batchreader.BooleanNestedBatchReader;
import com.facebook.presto.parquet.batchreader.Int32FlatBatchReader;
import com.facebook.presto.parquet.batchreader.Int32NestedBatchReader;
import com.facebook.presto.parquet.batchreader.Int64FlatBatchReader;
import com.facebook.presto.parquet.batchreader.Int64NestedBatchReader;
import com.facebook.presto.parquet.batchreader.Int64TimestampMicrosFlatBatchReader;
import com.facebook.presto.parquet.batchreader.Int64TimestampMicrosNestedBatchReader;
import com.facebook.presto.parquet.batchreader.LongDecimalFlatBatchReader;
import com.facebook.presto.parquet.batchreader.ShortDecimalFlatBatchReader;
import com.facebook.presto.parquet.batchreader.TimestampFlatBatchReader;
import com.facebook.presto.parquet.batchreader.TimestampNestedBatchReader;
import com.facebook.presto.parquet.reader.AbstractColumnReader;
import com.facebook.presto.parquet.reader.BinaryColumnReader;
import com.facebook.presto.parquet.reader.BooleanColumnReader;
import com.facebook.presto.parquet.reader.DoubleColumnReader;
import com.facebook.presto.parquet.reader.FloatColumnReader;
import com.facebook.presto.parquet.reader.IntColumnReader;
import com.facebook.presto.parquet.reader.LongColumnReader;
import com.facebook.presto.parquet.reader.LongDecimalColumnReader;
import com.facebook.presto.parquet.reader.LongTimeMicrosColumnReader;
import com.facebook.presto.parquet.reader.LongTimestampMicrosColumnReader;
import com.facebook.presto.parquet.reader.ShortDecimalColumnReader;
import com.facebook.presto.parquet.reader.TimestampColumnReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Optional;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.OriginalType;

public class ColumnReaderFactory {
    private static final Logger log = Logger.get(ColumnReaderFactory.class);

    private ColumnReaderFactory() {
    }

    public static ColumnReader createReader(RichColumnDescriptor descriptor, boolean batchReadEnabled) {
        if (batchReadEnabled) {
            boolean isNested = descriptor.getPath().length > 1;
            switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                case BOOLEAN: {
                    return isNested ? new BooleanNestedBatchReader(descriptor) : new BooleanFlatBatchReader(descriptor);
                }
                case INT32: {
                    if (!isNested && ParquetTypeUtils.isShortDecimalType(descriptor)) {
                        return new ShortDecimalFlatBatchReader(descriptor);
                    }
                }
                case FLOAT: {
                    return isNested ? new Int32NestedBatchReader(descriptor) : new Int32FlatBatchReader(descriptor);
                }
                case INT64: {
                    if (ParquetTypeUtils.isTimeStampMicrosType(descriptor)) {
                        return isNested ? new Int64TimestampMicrosNestedBatchReader(descriptor) : new Int64TimestampMicrosFlatBatchReader(descriptor);
                    }
                    if (!isNested && ParquetTypeUtils.isShortDecimalType(descriptor)) {
                        int precision = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)descriptor.getPrimitiveType().getLogicalTypeAnnotation()).getPrecision();
                        if (precision < 10) {
                            log.warn("PrimitiveTypeName is INT64 but precision is less then 10.");
                        }
                        return new ShortDecimalFlatBatchReader(descriptor);
                    }
                }
                case DOUBLE: {
                    return isNested ? new Int64NestedBatchReader(descriptor) : new Int64FlatBatchReader(descriptor);
                }
                case INT96: {
                    return isNested ? new TimestampNestedBatchReader(descriptor) : new TimestampFlatBatchReader(descriptor);
                }
                case BINARY: {
                    Optional<ColumnReader> decimalBatchColumnReader = ColumnReaderFactory.createDecimalBatchColumnReader(descriptor);
                    if (decimalBatchColumnReader.isPresent()) {
                        return decimalBatchColumnReader.get();
                    }
                    return isNested ? new BinaryNestedBatchReader(descriptor) : new BinaryFlatBatchReader(descriptor);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    Optional<ColumnReader> decimalBatchColumnReader;
                    if (isNested || !(decimalBatchColumnReader = ColumnReaderFactory.createDecimalBatchColumnReader(descriptor)).isPresent()) break;
                    return decimalBatchColumnReader.get();
                }
            }
        }
        switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return new BooleanColumnReader(descriptor);
            }
            case INT32: {
                return ColumnReaderFactory.createDecimalColumnReader(descriptor).orElse(new IntColumnReader(descriptor));
            }
            case INT64: {
                if (OriginalType.TIMESTAMP_MICROS.equals((Object)descriptor.getPrimitiveType().getOriginalType())) {
                    return new LongTimestampMicrosColumnReader(descriptor);
                }
                if (OriginalType.TIME_MICROS.equals((Object)descriptor.getPrimitiveType().getOriginalType())) {
                    return new LongTimeMicrosColumnReader(descriptor);
                }
                return ColumnReaderFactory.createDecimalColumnReader(descriptor).orElse(new LongColumnReader(descriptor));
            }
            case INT96: {
                return new TimestampColumnReader(descriptor);
            }
            case FLOAT: {
                return new FloatColumnReader(descriptor);
            }
            case DOUBLE: {
                return new DoubleColumnReader(descriptor);
            }
            case BINARY: {
                return ColumnReaderFactory.createDecimalColumnReader(descriptor).orElse(new BinaryColumnReader(descriptor));
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return ColumnReaderFactory.createDecimalColumnReader(descriptor).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, " type FIXED_LEN_BYTE_ARRAY supported as DECIMAL; got " + descriptor.getPrimitiveType().getOriginalType()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getType());
    }

    private static Optional<ColumnReader> createDecimalBatchColumnReader(RichColumnDescriptor descriptor) {
        if (ParquetTypeUtils.isDecimalType(descriptor)) {
            if (ParquetTypeUtils.isShortDecimalType(descriptor)) {
                return Optional.of(new ShortDecimalFlatBatchReader(descriptor));
            }
            return Optional.of(new LongDecimalFlatBatchReader(descriptor));
        }
        return Optional.empty();
    }

    private static Optional<AbstractColumnReader> createDecimalColumnReader(RichColumnDescriptor descriptor) {
        if (ParquetTypeUtils.isDecimalType(descriptor)) {
            if (ParquetTypeUtils.isShortDecimalType(descriptor)) {
                return Optional.of(new ShortDecimalColumnReader(descriptor));
            }
            return Optional.of(new LongDecimalColumnReader(descriptor));
        }
        return Optional.empty();
    }
}

