/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesReader;
import org.openjdk.jol.info.ClassLayout;

public abstract class AbstractInt64AndInt32ShortDecimalDeltaValuesDecoder
implements ValuesDecoder.ShortDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractInt64AndInt32ShortDecimalDeltaValuesDecoder.class).instanceSize();
    protected final ValuesReader delegate;

    public AbstractInt64AndInt32ShortDecimalDeltaValuesDecoder(ValuesReader delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            values[i] = this.readData();
        }
    }

    protected abstract long readData();

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.delegate.skip(length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

