/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.delta.BinaryDeltaValuesDecoder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.io.ParquetDecodingException;
import org.openjdk.jol.info.ClassLayout;

public class BinaryShortDecimalDeltaValuesDecoder
implements ValuesDecoder.ShortDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryShortDecimalDeltaValuesDecoder.class).instanceSize();
    private final BinaryDeltaValuesDecoder delegate;

    public BinaryShortDecimalDeltaValuesDecoder(ParquetEncoding encoding, int valueCount, ByteBufferInputStream bufferInputStream) throws IOException {
        Objects.requireNonNull(encoding, "encoding is null");
        Objects.requireNonNull(bufferInputStream, "bufferInputStream is null");
        this.delegate = new BinaryDeltaValuesDecoder(encoding, valueCount, bufferInputStream);
    }

    @Override
    public void readNext(long[] values, int offset, int length) throws IOException {
        ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = this.delegate.readNext(length);
        int bufferSize = valueBuffer.getBufferSize();
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[bufferSize + 1];
        this.delegate.readIntoBuffer(byteBuffer, 0, offsets, 0, valueBuffer);
        for (int i = 0; i < length; ++i) {
            int positionOffset = offsets[i];
            int positionLength = offsets[i + 1] - positionOffset;
            if (positionLength > 8) {
                throw new ParquetDecodingException("Unable to read BINARY type decimal of size " + positionLength + " as a short decimal");
            }
            values[offset + i] = ParquetTypeUtils.getShortDecimalValue(byteBuffer, positionOffset, positionLength);
        }
    }

    @Override
    public void skip(int length) throws IOException {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.delegate.skip(length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

