/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesReader;
import org.openjdk.jol.info.ClassLayout;

public class FixedLenByteArrayLongDecimalDeltaValueDecoder
implements ValuesDecoder.LongDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedLenByteArrayLongDecimalDeltaValueDecoder.class).instanceSize();
    private final ValuesReader delegate;

    public FixedLenByteArrayLongDecimalDeltaValueDecoder(ValuesReader delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        int endOffset = (offset + length) * 2;
        for (int currentOutputOffset = offset * 2; currentOutputOffset < endOffset; currentOutputOffset += 2) {
            byte[] inputBytes = this.delegate.readBytes().getBytes();
            Slice slice = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(inputBytes));
            values[currentOutputOffset] = slice.getLong(0);
            values[currentOutputOffset + 1] = slice.getLong(8);
        }
    }

    @Override
    public void skip(int length) {
        this.delegate.skip(length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

