/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.FixedLenByteArrayShortDecimalPlainValuesDecoder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.openjdk.jol.info.ClassLayout;

public class FixedLenByteArrayShortDecimalDeltaValueDecoder
implements ValuesDecoder.ShortDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedLenByteArrayShortDecimalDeltaValueDecoder.class).instanceSize();
    private final ValuesReader delegate;
    private final ColumnDescriptor descriptor;
    private final int typeLength;

    public FixedLenByteArrayShortDecimalDeltaValueDecoder(ValuesReader delegate, ColumnDescriptor descriptor) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        LogicalTypeAnnotation logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation).getPrecision() <= 18 ? 1 : 0) != 0, (String)"Column %s is not a short decimal", (Object)descriptor);
        this.typeLength = descriptor.getPrimitiveType().getTypeLength();
        Preconditions.checkArgument((this.typeLength > 0 && this.typeLength <= 16 ? 1 : 0) != 0, (String)"Expected column %s to have type length in range (1-16)", (Object)descriptor);
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        int bytesOffset = 0;
        int bytesLength = this.typeLength;
        if (this.typeLength > 8) {
            bytesOffset = this.typeLength - 8;
            bytesLength = 8;
        }
        for (int i = offset; i < offset + length; ++i) {
            byte[] bytes = this.delegate.readBytes().getBytes();
            FixedLenByteArrayShortDecimalPlainValuesDecoder.checkBytesFitInShortDecimal(bytes, 0, bytesOffset, this.descriptor);
            values[i] = ParquetTypeUtils.getShortDecimalValue(bytes, bytesOffset, bytesLength);
        }
    }

    @Override
    public void skip(int length) {
        this.delegate.skip(length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

