/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BinaryPlainValuesDecoder;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BinaryLongDecimalPlainValuesDecoder
implements ValuesDecoder.LongDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryLongDecimalPlainValuesDecoder.class).instanceSize();
    private final BinaryPlainValuesDecoder delegate;

    public BinaryLongDecimalPlainValuesDecoder(byte[] buffer, int bufOffset, int bufLength) {
        Objects.requireNonNull(buffer, "buffer is null");
        this.delegate = new BinaryPlainValuesDecoder(buffer, bufOffset, bufLength);
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        BinaryPlainValuesDecoder.PlainValueBuffer valueBuffer = (BinaryPlainValuesDecoder.PlainValueBuffer)this.delegate.readNext(length);
        int bufferSize = valueBuffer.getBufferSize();
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[bufferSize + 1];
        this.delegate.readIntoBuffer(byteBuffer, 0, offsets, 0, valueBuffer);
        for (int i = 0; i < length; ++i) {
            int positionOffset = offsets[i];
            int positionLength = offsets[i + 1] - positionOffset;
            byte[] temp = Arrays.copyOfRange(byteBuffer, positionOffset, positionOffset + positionLength);
            Slice slice = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(temp));
            values[2 * (offset + i)] = slice.getLong(0);
            values[2 * (offset + i) + 1] = slice.getLong(8);
        }
    }

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.delegate.skip(length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

