/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BinaryPlainValuesDecoder;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.openjdk.jol.info.ClassLayout;

public class BinaryShortDecimalPlainValuesDecoder
implements ValuesDecoder.ShortDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryShortDecimalPlainValuesDecoder.class).instanceSize();
    private final BinaryPlainValuesDecoder delegate;

    public BinaryShortDecimalPlainValuesDecoder(byte[] byteBuffer, int bufferOffset, int length) {
        Objects.requireNonNull(byteBuffer, "buffer is null");
        this.delegate = new BinaryPlainValuesDecoder(byteBuffer, bufferOffset, length);
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = this.delegate.readNext(length);
        int bufferSize = valueBuffer.getBufferSize();
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[bufferSize + 1];
        this.delegate.readIntoBuffer(byteBuffer, 0, offsets, 0, valueBuffer);
        for (int i = 0; i < length; ++i) {
            int positionOffset = offsets[i];
            int positionLength = offsets[i + 1] - positionOffset;
            if (positionLength > 8) {
                throw new ParquetDecodingException("Unable to read BINARY type decimal of size " + positionLength + " as a short decimal");
            }
            values[offset + i] = ParquetTypeUtils.getShortDecimalValue(byteBuffer, positionOffset, positionLength);
        }
    }

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.delegate.skip(length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

