/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BinaryLongDecimalPlainValuesDecoder;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.math.BigInteger;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class FixedLenByteArrayLongDecimalPlainValuesDecoder
implements ValuesDecoder.LongDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryLongDecimalPlainValuesDecoder.class).instanceSize();
    private final int typeLength;
    private final byte[] inputBytes;
    private final byte[] byteBuffer;
    private final int bufferEnd;
    private int bufferOffset;

    public FixedLenByteArrayLongDecimalPlainValuesDecoder(int typeLength, byte[] byteBuffer, int bufferOffset, int length) {
        Preconditions.checkArgument((typeLength > 0 && typeLength <= 16 ? 1 : 0) != 0, (String)"typeLength %s should be in range (1-16) for a long decimal", (int)typeLength);
        this.typeLength = typeLength;
        this.inputBytes = new byte[typeLength];
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer is null");
        this.bufferOffset = bufferOffset;
        this.bufferEnd = bufferOffset + length;
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        int localBufferOffset = this.bufferOffset;
        int endOffset = (offset + length) * 2;
        for (int currentOutputOffset = offset * 2; currentOutputOffset < endOffset; currentOutputOffset += 2) {
            System.arraycopy(this.byteBuffer, localBufferOffset, this.inputBytes, 0, this.typeLength);
            Slice slice = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(this.inputBytes));
            values[currentOutputOffset] = slice.getLong(0);
            values[currentOutputOffset + 1] = slice.getLong(8);
            localBufferOffset += this.typeLength;
        }
        this.bufferOffset = localBufferOffset;
    }

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((this.bufferOffset + length * this.typeLength <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.bufferOffset += length * this.typeLength;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.byteBuffer) + SizeOf.sizeOf((byte[])this.inputBytes);
    }
}

