/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.batchreader.SimpleSliceInputStream;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.ShortDecimalFixedWidthByteArrayBatchDecoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.openjdk.jol.info.ClassLayout;

public class FixedLenByteArrayShortDecimalPlainValuesDecoder
implements ValuesDecoder.ShortDecimalValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(FixedLenByteArrayShortDecimalPlainValuesDecoder.class).instanceSize();
    private final ColumnDescriptor columnDescriptor;
    private final int typeLength;
    private final ShortDecimalFixedWidthByteArrayBatchDecoder decimalValueDecoder;
    private final SimpleSliceInputStream input;

    public FixedLenByteArrayShortDecimalPlainValuesDecoder(ColumnDescriptor columnDescriptor, byte[] byteBuffer, int bufferOffset, int length) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
        this.typeLength = columnDescriptor.getPrimitiveType().getTypeLength();
        Preconditions.checkArgument((this.typeLength > 0 && this.typeLength <= 16 ? 1 : 0) != 0, (String)"Expected column %s to have type length in range (1-16)", (Object)columnDescriptor);
        this.decimalValueDecoder = new ShortDecimalFixedWidthByteArrayBatchDecoder(Math.min(this.typeLength, 8));
        this.input = new SimpleSliceInputStream(Slices.wrappedBuffer((byte[])Objects.requireNonNull(byteBuffer, "byteBuffer is null"), (int)bufferOffset, (int)length));
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        this.input.ensureBytesAvailable(this.typeLength * length);
        if (this.typeLength <= 8) {
            this.decimalValueDecoder.getShortDecimalValues(this.input, values, offset, length);
            return;
        }
        int extraBytesLength = this.typeLength - 8;
        byte[] inputBytes = this.input.getByteArray();
        int inputBytesOffset = this.input.getByteArrayOffset();
        for (int i = offset; i < offset + length; ++i) {
            FixedLenByteArrayShortDecimalPlainValuesDecoder.checkBytesFitInShortDecimal(inputBytes, inputBytesOffset, extraBytesLength, this.columnDescriptor);
            values[i] = ParquetTypeUtils.getShortDecimalValue(inputBytes, inputBytesOffset + extraBytesLength, 8);
            inputBytesOffset += this.typeLength;
        }
        this.input.skip(length * this.typeLength);
    }

    public static void checkBytesFitInShortDecimal(byte[] bytes, int offset, int length, ColumnDescriptor descriptor) {
        int endOffset = offset + length;
        byte expectedValue = (byte)(bytes[endOffset] >> 7);
        for (int i = offset; i < endOffset; ++i) {
            if (bytes[i] == expectedValue) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Could not read unscaled value into a short decimal from column " + descriptor);
        }
    }

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.input.skip(length * this.typeLength);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

