/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.parquet.batchreader.BytesUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import org.openjdk.jol.info.ClassLayout;

public class Int32PlainValuesDecoder
implements ValuesDecoder.Int32ValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int32PlainValuesDecoder.class).instanceSize();
    private final byte[] byteBuffer;
    private final int bufferEnd;
    private int bufferOffset;

    public Int32PlainValuesDecoder(byte[] byteBuffer, int bufferOffset, int length) {
        this.byteBuffer = byteBuffer;
        this.bufferOffset = bufferOffset;
        this.bufferEnd = bufferOffset + length;
    }

    @Override
    public void readNext(int[] values, int offset, int length) {
        Preconditions.checkArgument((this.bufferOffset + length * 4 <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
        Preconditions.checkArgument((length >= 0 && offset >= 0 ? 1 : 0) != 0, (String)"invalid read request: offset %s, length", (int)offset, (int)length);
        int endOffset = offset + length;
        byte[] localByteBuffer = this.byteBuffer;
        int localBufferOffset = this.bufferOffset;
        while (offset < endOffset) {
            values[offset++] = BytesUtils.getInt(localByteBuffer, localBufferOffset);
            localBufferOffset += 4;
        }
        this.bufferOffset = localBufferOffset;
    }

    @Override
    public void skip(int length) {
        Preconditions.checkArgument((this.bufferOffset + length * 4 <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        this.bufferOffset += length * 4;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.byteBuffer);
    }
}

