/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BinaryRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.BinaryBatchDictionary;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Objects;

public class LongDecimalRLEDictionaryValuesDecoder
extends BaseRLEBitPackedDecoder
implements ValuesDecoder.LongDecimalValuesDecoder {
    private final BinaryRLEDictionaryValuesDecoder delegate;

    public LongDecimalRLEDictionaryValuesDecoder(int bitWidth, InputStream inputStream, BinaryBatchDictionary dictionary) {
        super(Integer.MAX_VALUE, bitWidth, inputStream);
        Objects.requireNonNull(dictionary, "dictionary is null");
        this.delegate = new BinaryRLEDictionaryValuesDecoder(bitWidth, inputStream, dictionary);
    }

    @Override
    public void readNext(long[] values, int offset, int length) throws IOException {
        ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = this.delegate.readNext(length);
        int bufferSize = valueBuffer.getBufferSize();
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[bufferSize + 1];
        this.delegate.readIntoBuffer(byteBuffer, 0, offsets, 0, valueBuffer);
        for (int i = 0; i < length; ++i) {
            int positionOffset = offsets[i];
            int positionLength = offsets[i + 1] - positionOffset;
            byte[] temp = new byte[positionLength];
            System.arraycopy(byteBuffer, positionOffset, temp, 0, positionLength);
            Slice slice = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(temp));
            values[2 * (offset + i)] = slice.getLong(0);
            values[2 * (offset + i) + 1] = slice.getLong(8);
        }
    }

    @Override
    public void skip(int length) throws IOException {
        this.delegate.skip(length);
    }
}

