/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BinaryRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.BinaryBatchDictionary;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;

public class ShortDecimalRLEDictionaryValuesDecoder
extends BaseRLEBitPackedDecoder
implements ValuesDecoder.ShortDecimalValuesDecoder {
    private final BinaryRLEDictionaryValuesDecoder delegate;

    public ShortDecimalRLEDictionaryValuesDecoder(int bitWidth, InputStream inputStream, BinaryBatchDictionary dictionary) {
        super(Integer.MAX_VALUE, bitWidth, inputStream);
        Objects.requireNonNull(dictionary, "dictionary is null");
        this.delegate = new BinaryRLEDictionaryValuesDecoder(bitWidth, inputStream, dictionary);
    }

    @Override
    public void readNext(long[] values, int offset, int length) throws IOException {
        ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = this.delegate.readNext(length);
        int bufferSize = valueBuffer.getBufferSize();
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[bufferSize + 1];
        this.delegate.readIntoBuffer(byteBuffer, 0, offsets, 0, valueBuffer);
        for (int i = 0; i < length; ++i) {
            int positionOffset = offsets[i];
            int positionLength = offsets[i + 1] - positionOffset;
            if (positionLength > 8) {
                throw new ParquetDecodingException("Unable to read BINARY type decimal of size " + positionLength + " as a short decimal");
            }
            values[offset + i] = ParquetTypeUtils.getShortDecimalValue(byteBuffer, positionOffset, positionLength);
        }
    }

    @Override
    public void skip(int length) throws IOException {
        this.delegate.skip(length);
    }
}

