/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.cache;

import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.parquet.cache.ParquetFileMetadata;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.parquet.crypto.InternalFileDecryptor;

public class CachingParquetMetadataSource
implements ParquetMetadataSource {
    private final Cache<ParquetDataSourceId, ParquetFileMetadata> cache;
    private final ParquetMetadataSource delegate;

    public CachingParquetMetadataSource(Cache<ParquetDataSourceId, ParquetFileMetadata> cache, ParquetMetadataSource delegate) {
        this.cache = Objects.requireNonNull(cache, "cache is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public ParquetFileMetadata getParquetMetadata(ParquetDataSource parquetDataSource, long fileSize, boolean cacheable, long modificationTime, Optional<InternalFileDecryptor> fileDecryptor, boolean readMaskedValue) throws IOException {
        try {
            if (cacheable) {
                ParquetFileMetadata fileMetadataCache = (ParquetFileMetadata)this.cache.get((Object)parquetDataSource.getId(), () -> this.delegate.getParquetMetadata(parquetDataSource, fileSize, cacheable, modificationTime, fileDecryptor, readMaskedValue));
                if (fileMetadataCache.getModificationTime() != modificationTime) {
                    this.cache.invalidate((Object)parquetDataSource.getId());
                    fileMetadataCache = this.delegate.getParquetMetadata(parquetDataSource, fileSize, cacheable, modificationTime, fileDecryptor, readMaskedValue);
                    this.cache.put((Object)parquetDataSource.getId(), (Object)fileMetadataCache);
                }
                return fileMetadataCache;
            }
            return this.delegate.getParquetMetadata(parquetDataSource, fileSize, cacheable, modificationTime, fileDecryptor, readMaskedValue);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw new IOException("Unexpected error in parquet metadata reading after cache miss", e.getCause());
        }
    }
}

