/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.AbstractColumnReader;
import java.util.concurrent.TimeUnit;

public class LongTimeMicrosColumnReader
extends AbstractColumnReader {
    public LongTimeMicrosColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long utcMillis = TimeUnit.MICROSECONDS.toMillis(this.valuesReader.readLong());
            if (type instanceof TimeWithTimeZoneType) {
                type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            } else {
                type.writeLong(blockBuilder, utcMillis);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readLong();
        }
    }
}

