/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ParquetDataOutput;
import com.facebook.presto.parquet.writer.PrimitiveColumnWriter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class PrimitiveColumnWriterV1
extends PrimitiveColumnWriter {
    private final ValuesWriter definitionLevelWriter;
    private final ValuesWriter repetitionLevelWriter;

    public PrimitiveColumnWriterV1(Type type, ColumnDescriptor columnDescriptor, PrimitiveValueWriter primitiveValueWriter, ValuesWriter definitionLevelWriter, ValuesWriter repetitionLevelWriter, CompressionCodecName compressionCodecName, int pageSizeThreshold) {
        super(type, columnDescriptor, primitiveValueWriter, compressionCodecName, pageSizeThreshold);
        this.definitionLevelWriter = Objects.requireNonNull(definitionLevelWriter, "definitionLevelWriter is null");
        this.repetitionLevelWriter = Objects.requireNonNull(repetitionLevelWriter, "repetitionLevelWriter is null");
    }

    @Override
    protected void writeDefinitionAndRepetitionLevels(ColumnChunk current) {
        Iterator<Integer> defIterator = DefinitionLevelIterables.getIterator(current.getDefinitionLevelIterables());
        while (defIterator.hasNext()) {
            int next = defIterator.next();
            this.definitionLevelWriter.writeInteger(next);
            if (next != this.maxDefinitionLevel) {
                ++this.currentPageNullCounts;
            }
            ++this.valueCount;
        }
        Iterator<Integer> repIterator = RepetitionLevelIterables.getIterator(current.getRepetitionLevelIterables());
        while (repIterator.hasNext()) {
            int next = repIterator.next();
            this.repetitionLevelWriter.writeInteger(next);
        }
    }

    @Override
    protected void flushCurrentPageToBuffer() throws IOException {
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        BytesInput bytesInput = BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.copy((BytesInput)this.repetitionLevelWriter.getBytes()), BytesInput.copy((BytesInput)this.definitionLevelWriter.getBytes()), BytesInput.copy((BytesInput)this.primitiveValueWriter.getBytes())});
        ParquetDataOutput pageData = this.compressor != null ? this.compressor.compress(bytesInput) : ParquetDataOutput.createDataOutput(bytesInput);
        long uncompressedSize = bytesInput.size();
        long compressedSize = pageData.size();
        ByteArrayOutputStream pageHeaderOutputStream = new ByteArrayOutputStream();
        Statistics<?> statistics = this.primitiveValueWriter.getStatistics();
        statistics.incrementNumNulls((long)this.currentPageNullCounts);
        this.columnStatistics.mergeStatistics(statistics);
        this.parquetMetadataConverter.writeDataPageV1Header((int)uncompressedSize, (int)compressedSize, this.valueCount, this.repetitionLevelWriter.getEncoding(), this.definitionLevelWriter.getEncoding(), this.primitiveValueWriter.getEncoding(), (OutputStream)pageHeaderOutputStream);
        ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])pageHeaderOutputStream.toByteArray()));
        outputDataStreams.add((Object)pageHeader);
        outputDataStreams.add((Object)pageData);
        ImmutableList dataOutputs = outputDataStreams.build();
        this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
        this.totalCompressedSize += pageHeader.size() + compressedSize;
        this.totalValues += (long)this.valueCount;
        this.pageBuffer.addAll(dataOutputs);
        this.encodings.add(this.repetitionLevelWriter.getEncoding());
        this.encodings.add(this.definitionLevelWriter.getEncoding());
        this.encodings.add(this.primitiveValueWriter.getEncoding());
        this.valueCount = 0;
        this.currentPageNullCounts = 0;
        this.repetitionLevelWriter.reset();
        this.definitionLevelWriter.reset();
        this.primitiveValueWriter.reset();
    }

    @Override
    public long getBufferedBytes() {
        return this.pageBuffer.stream().mapToLong(ParquetDataOutput::size).sum() + this.definitionLevelWriter.getBufferedSize() + this.repetitionLevelWriter.getBufferedSize() + this.primitiveValueWriter.getBufferedSize();
    }
}

