/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import java.util.Objects;

public class ArithmeticUnaryExpression
extends Expression {
    private final Expression value;
    private final Sign sign;

    public ArithmeticUnaryExpression(Sign sign, Expression value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(sign, "sign is null");
        this.value = value;
        this.sign = sign;
    }

    public static ArithmeticUnaryExpression positive(Expression value) {
        return new ArithmeticUnaryExpression(Sign.PLUS, value);
    }

    public static ArithmeticUnaryExpression negative(Expression value) {
        return new ArithmeticUnaryExpression(Sign.MINUS, value);
    }

    public Expression getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticUnary(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticUnaryExpression that = (ArithmeticUnaryExpression)o;
        if (this.sign != that.sign) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.sign.hashCode();
        return result;
    }

    public static enum Sign {
        PLUS,
        MINUS;

    }
}

