/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SelectItem;
import java.util.Objects;
import java.util.Optional;

public class SingleColumn
extends SelectItem {
    private final Optional<String> alias;
    private final Expression expression;

    public SingleColumn(Expression expression, Optional<String> alias) {
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(alias, "alias is null");
        this.expression = expression;
        this.alias = alias;
    }

    public SingleColumn(Expression expression, String alias) {
        this(expression, Optional.of(alias));
    }

    public SingleColumn(Expression expression) {
        this(expression, Optional.empty());
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    @Override
    public String toString() {
        if (this.alias.isPresent()) {
            return this.expression.toString() + " " + this.alias.get();
        }
        return this.expression.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }
}

