/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LogicalBinaryExpression
extends Expression {
    private final Type type;
    private final Expression left;
    private final Expression right;

    public LogicalBinaryExpression(Type type, Expression left, Expression right) {
        this(Optional.empty(), type, left, right);
    }

    public LogicalBinaryExpression(NodeLocation location, Type type, Expression left, Expression right) {
        this(Optional.of(location), type, left, right);
    }

    private LogicalBinaryExpression(Optional<NodeLocation> location, Type type, Expression left, Expression right) {
        super(location);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.type = type;
        this.left = left;
        this.right = right;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLogicalBinaryExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public static LogicalBinaryExpression and(Expression left, Expression right) {
        return new LogicalBinaryExpression(Optional.empty(), Type.AND, left, right);
    }

    public static LogicalBinaryExpression or(Expression left, Expression right) {
        return new LogicalBinaryExpression(Optional.empty(), Type.OR, left, right);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalBinaryExpression that = (LogicalBinaryExpression)o;
        return this.type == that.type && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right});
    }

    public static enum Type {
        AND,
        OR;


        public Type flip() {
            switch (this) {
                case AND: {
                    return OR;
                }
                case OR: {
                    return AND;
                }
            }
            throw new IllegalArgumentException("Unsupported logical expression type: " + (Object)((Object)this));
        }
    }
}

