/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class EnumLiteral
extends Literal {
    private final Object value;
    private final String type;

    public EnumLiteral(String type, Object value) {
        this(Optional.empty(), type, value);
    }

    private EnumLiteral(Optional<NodeLocation> location, String type, Object value) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitEnumLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumLiteral that = (EnumLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

