/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LogicalBinaryExpression
extends Expression {
    private final Operator operator;
    private final Expression left;
    private final Expression right;

    public LogicalBinaryExpression(Operator operator, Expression left, Expression right) {
        this(Optional.empty(), operator, left, right);
    }

    public LogicalBinaryExpression(NodeLocation location, Operator operator, Expression left, Expression right) {
        this(Optional.of(location), operator, left, right);
    }

    private LogicalBinaryExpression(Optional<NodeLocation> location, Operator operator, Expression left, Expression right) {
        super(location);
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLogicalBinaryExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public static LogicalBinaryExpression and(Expression left, Expression right) {
        return new LogicalBinaryExpression(Optional.empty(), Operator.AND, left, right);
    }

    public static LogicalBinaryExpression or(Expression left, Expression right) {
        return new LogicalBinaryExpression(Optional.empty(), Operator.OR, left, right);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalBinaryExpression that = (LogicalBinaryExpression)o;
        return this.operator == that.operator && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    public static enum Operator {
        AND,
        OR;


        public Operator flip() {
            switch (this) {
                case AND: {
                    return OR;
                }
                case OR: {
                    return AND;
                }
            }
            throw new IllegalArgumentException("Unsupported logical expression type: " + (Object)((Object)this));
        }
    }
}

