/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TableVersionExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExpressionFormatter {
    private static final ThreadLocal<DecimalFormat> doubleFormatter = ThreadLocal.withInitial(() -> new DecimalFormat("0.###################E0###", new DecimalFormatSymbols(Locale.US)));

    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression, Optional<List<Expression>> parameters) {
        return (String)new Formatter(parameters).process(expression, null);
    }

    public static String formatQualifiedName(QualifiedName name) {
        return name.getParts().stream().map(ExpressionFormatter::formatIdentifier).collect(Collectors.joining("."));
    }

    public static String formatIdentifier(String s) {
        return '\"' + s.replace("\"", "\"\"") + '\"';
    }

    static String formatStringLiteral(String s) {
        s = s.replace("'", "''");
        if (CharMatcher.inRange((char)' ', (char)'~').matchesAllOf((CharSequence)s)) {
            return "'" + s + "'";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("U&'");
        PrimitiveIterator.OfInt iterator = s.codePoints().iterator();
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            Preconditions.checkArgument((codePoint >= 0 ? 1 : 0) != 0, (String)"Invalid UTF-8 encoding in characters: %s", (Object)s);
            if (ExpressionFormatter.isAsciiPrintable(codePoint)) {
                char ch = (char)codePoint;
                if (ch == '\\') {
                    builder.append(ch);
                }
                builder.append(ch);
                continue;
            }
            if (codePoint <= 65535) {
                builder.append('\\');
                builder.append(String.format("%04X", codePoint));
                continue;
            }
            builder.append("\\+");
            builder.append(String.format("%06X", codePoint));
        }
        builder.append("'");
        return builder.toString();
    }

    static String formatOrderBy(OrderBy orderBy, Optional<List<Expression>> parameters) {
        return "ORDER BY " + ExpressionFormatter.formatSortItems(orderBy.getSortItems(), parameters);
    }

    static String formatSortItems(List<SortItem> sortItems, Optional<List<Expression>> parameters) {
        return Joiner.on((String)", ").join(sortItems.stream().map(ExpressionFormatter.sortItemFormatterFunction(parameters)).iterator());
    }

    static String formatGroupBy(List<GroupingElement> groupingElements) {
        return ExpressionFormatter.formatGroupBy(groupingElements, Optional.empty());
    }

    static String formatGroupBy(List<GroupingElement> groupingElements, Optional<List<Expression>> parameters) {
        ImmutableList.Builder resultStrings = ImmutableList.builder();
        for (GroupingElement groupingElement : groupingElements) {
            String result = "";
            if (groupingElement instanceof SimpleGroupBy) {
                List<Expression> columns = ((SimpleGroupBy)groupingElement).getExpressions();
                result = columns.size() == 1 ? ExpressionFormatter.formatExpression((Expression)Iterables.getOnlyElement(columns), parameters) : ExpressionFormatter.formatGroupingSet(columns, parameters);
            } else if (groupingElement instanceof GroupingSets) {
                result = String.format("GROUPING SETS (%s)", Joiner.on((String)", ").join(((GroupingSets)groupingElement).getSets().stream().map(e -> ExpressionFormatter.formatGroupingSet(e, parameters)).iterator()));
            } else if (groupingElement instanceof Cube) {
                result = String.format("CUBE %s", ExpressionFormatter.formatGroupingSet(((Cube)groupingElement).getExpressions(), parameters));
            } else if (groupingElement instanceof Rollup) {
                result = String.format("ROLLUP %s", ExpressionFormatter.formatGroupingSet(((Rollup)groupingElement).getExpressions(), parameters));
            }
            resultStrings.add((Object)result);
        }
        return Joiner.on((String)", ").join((Iterable)resultStrings.build());
    }

    private static boolean isAsciiPrintable(int codePoint) {
        return codePoint < 127 && codePoint >= 32;
    }

    private static String formatGroupingSet(List<Expression> groupingSet, Optional<List<Expression>> parameters) {
        return String.format("(%s)", Joiner.on((String)", ").join(groupingSet.stream().map(e -> ExpressionFormatter.formatExpression(e, parameters)).iterator()));
    }

    private static Function<SortItem, String> sortItemFormatterFunction(Optional<List<Expression>> parameters) {
        return input -> {
            StringBuilder builder = new StringBuilder();
            builder.append(ExpressionFormatter.formatExpression(input.getSortKey(), parameters));
            switch (input.getOrdering()) {
                case ASCENDING: {
                    builder.append(" ASC");
                    break;
                }
                case DESCENDING: {
                    builder.append(" DESC");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ordering: " + (Object)((Object)input.getOrdering()));
                }
            }
            switch (input.getNullOrdering()) {
                case FIRST: {
                    builder.append(" NULLS FIRST");
                    break;
                }
                case LAST: {
                    builder.append(" NULLS LAST");
                    break;
                }
                case UNDEFINED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown null ordering: " + (Object)((Object)input.getNullOrdering()));
                }
            }
            return builder.toString();
        };
    }

    public static class Formatter
    extends AstVisitor<String, Void> {
        private final Optional<List<Expression>> parameters;

        public Formatter(Optional<List<Expression>> parameters) {
            this.parameters = parameters;
        }

        @Override
        protected String visitNode(Node node, Void context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String visitRow(Row node, Void context) {
            return "ROW (" + Joiner.on((String)", ").join((Iterable)node.getItems().stream().map(child -> (String)this.process((Node)child, context)).collect(Collectors.toList())) + ")";
        }

        @Override
        protected String visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), node.getClass().getSimpleName()));
        }

        @Override
        protected String visitAtTimeZone(AtTimeZone node, Void context) {
            return (String)this.process(node.getValue(), context) + " AT TIME ZONE " + (String)this.process(node.getTimeZone(), context);
        }

        @Override
        protected String visitCurrentUser(CurrentUser node, Void context) {
            return "CURRENT_USER";
        }

        @Override
        protected String visitCurrentTime(CurrentTime node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getFunction().getName());
            if (node.getPrecision() != null) {
                builder.append('(').append(node.getPrecision()).append(')');
            }
            return builder.toString();
        }

        @Override
        protected String visitExtract(Extract node, Void context) {
            return "EXTRACT(" + (Object)((Object)node.getField()) + " FROM " + (String)this.process(node.getExpression(), context) + ")";
        }

        @Override
        protected String visitBooleanLiteral(BooleanLiteral node, Void context) {
            return String.valueOf(node.getValue());
        }

        @Override
        protected String visitStringLiteral(StringLiteral node, Void context) {
            return ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        @Override
        protected String visitCharLiteral(CharLiteral node, Void context) {
            return "CHAR " + ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        @Override
        protected String visitBinaryLiteral(BinaryLiteral node, Void context) {
            return "X'" + node.toHexString() + "'";
        }

        @Override
        protected String visitParameter(Parameter node, Void context) {
            if (this.parameters.isPresent()) {
                Preconditions.checkArgument((node.getPosition() < this.parameters.get().size() ? 1 : 0) != 0, (String)"Invalid parameter number %s.  Max value is %s", (int)node.getPosition(), (int)(this.parameters.get().size() - 1));
                return (String)this.process(this.parameters.get().get(node.getPosition()), context);
            }
            return "?";
        }

        @Override
        protected String visitArrayConstructor(ArrayConstructor node, Void context) {
            ImmutableList.Builder valueStrings = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                valueStrings.add((Object)SqlFormatter.formatSql(value, this.parameters));
            }
            return "ARRAY[" + Joiner.on((String)",").join((Iterable)valueStrings.build()) + "]";
        }

        @Override
        protected String visitSubscriptExpression(SubscriptExpression node, Void context) {
            return SqlFormatter.formatSql(node.getBase(), this.parameters) + "[" + SqlFormatter.formatSql(node.getIndex(), this.parameters) + "]";
        }

        @Override
        protected String visitLongLiteral(LongLiteral node, Void context) {
            return Long.toString(node.getValue());
        }

        @Override
        protected String visitDoubleLiteral(DoubleLiteral node, Void context) {
            return ((DecimalFormat)doubleFormatter.get()).format(node.getValue());
        }

        @Override
        protected String visitDecimalLiteral(DecimalLiteral node, Void context) {
            return "DECIMAL '" + node.getValue() + "'";
        }

        @Override
        protected String visitGenericLiteral(GenericLiteral node, Void context) {
            return node.getType() + " " + ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        @Override
        protected String visitTimeLiteral(TimeLiteral node, Void context) {
            return "TIME '" + node.getValue() + "'";
        }

        @Override
        protected String visitTimestampLiteral(TimestampLiteral node, Void context) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        @Override
        protected String visitNullLiteral(NullLiteral node, Void context) {
            return "null";
        }

        @Override
        protected String visitIntervalLiteral(IntervalLiteral node, Void context) {
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "- " : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append(" '").append(node.getValue()).append("' ").append((Object)node.getStartField());
            if (node.getEndField().isPresent()) {
                builder.append(" TO ").append((Object)node.getEndField().get());
            }
            return builder.toString();
        }

        @Override
        protected String visitSubqueryExpression(SubqueryExpression node, Void context) {
            return "(" + SqlFormatter.formatSql(node.getQuery(), this.parameters) + ")";
        }

        @Override
        protected String visitExists(ExistsPredicate node, Void context) {
            return "(EXISTS " + SqlFormatter.formatSql(node.getSubquery(), this.parameters) + ")";
        }

        @Override
        protected String visitIdentifier(Identifier node, Void context) {
            if (!node.isDelimited()) {
                return node.getValue();
            }
            return '\"' + node.getValue().replace("\"", "\"\"") + '\"';
        }

        @Override
        protected String visitLambdaArgumentDeclaration(LambdaArgumentDeclaration node, Void context) {
            return ExpressionFormatter.formatExpression(node.getName(), this.parameters);
        }

        @Override
        protected String visitSymbolReference(SymbolReference node, Void context) {
            return ExpressionFormatter.formatIdentifier(node.getName());
        }

        @Override
        protected String visitDereferenceExpression(DereferenceExpression node, Void context) {
            String baseString = (String)this.process(node.getBase(), context);
            return baseString + "." + (String)this.process(node.getField());
        }

        @Override
        public String visitFieldReference(FieldReference node, Void context) {
            return ":input(" + node.getFieldIndex() + ")";
        }

        @Override
        protected String visitFunctionCall(FunctionCall node, Void context) {
            StringBuilder builder = new StringBuilder();
            String arguments = this.joinExpressions(node.getArguments());
            if (node.getArguments().isEmpty() && "count".equalsIgnoreCase(node.getName().getSuffix())) {
                arguments = "*";
            }
            if (node.isDistinct()) {
                arguments = "DISTINCT " + arguments;
            }
            builder.append(ExpressionFormatter.formatQualifiedName(node.getName())).append('(').append(arguments);
            if (node.getOrderBy().isPresent()) {
                builder.append(' ').append(ExpressionFormatter.formatOrderBy(node.getOrderBy().get(), this.parameters));
            }
            builder.append(')');
            if (node.isIgnoreNulls()) {
                builder.append(" IGNORE NULLS");
            }
            if (node.getFilter().isPresent()) {
                builder.append(" FILTER ").append(this.visitFilter(node.getFilter().get(), context));
            }
            if (node.getWindow().isPresent()) {
                builder.append(" OVER ").append(this.visitWindow(node.getWindow().get(), context));
            }
            return builder.toString();
        }

        @Override
        protected String visitLambdaExpression(LambdaExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            Joiner.on((String)", ").appendTo(builder, node.getArguments());
            builder.append(") -> ");
            builder.append((String)this.process(node.getBody(), context));
            return builder.toString();
        }

        @Override
        protected String visitBindExpression(BindExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"$INTERNAL$BIND\"(");
            for (Expression value : node.getValues()) {
                builder.append((String)this.process(value, context) + ", ");
            }
            builder.append((String)this.process(node.getFunction(), context) + ")");
            return builder.toString();
        }

        @Override
        protected String visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().toString(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitNotExpression(NotExpression node, Void context) {
            return "(NOT " + (String)this.process(node.getValue(), context) + ")";
        }

        @Override
        protected String visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitIsNullPredicate(IsNullPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IS NULL)";
        }

        @Override
        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IS NOT NULL)";
        }

        @Override
        protected String visitNullIfExpression(NullIfExpression node, Void context) {
            return "NULLIF(" + (String)this.process(node.getFirst(), context) + ", " + (String)this.process(node.getSecond(), context) + ')';
        }

        @Override
        protected String visitIfExpression(IfExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("IF(").append((String)this.process(node.getCondition(), context)).append(", ").append((String)this.process(node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                builder.append(", ").append((String)this.process(node.getFalseValue().get(), context));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String visitTryExpression(TryExpression node, Void context) {
            return "TRY(" + (String)this.process(node.getInnerExpression(), context) + ")";
        }

        @Override
        protected String visitCoalesceExpression(CoalesceExpression node, Void context) {
            return "COALESCE(" + this.joinExpressions(node.getOperands()) + ")";
        }

        @Override
        protected String visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            String value = (String)this.process(node.getValue(), context);
            switch (node.getSign()) {
                case MINUS: {
                    String separator = value.startsWith("-") ? " " : "";
                    return "-" + separator + value;
                }
                case PLUS: {
                    return "+" + value;
                }
            }
            throw new UnsupportedOperationException("Unsupported sign: " + (Object)((Object)node.getSign()));
        }

        @Override
        protected String visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getOperator().getValue(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitLikePredicate(LikePredicate node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process(node.getValue(), context)).append(" LIKE ").append((String)this.process(node.getPattern(), context));
            node.getEscape().ifPresent(escape -> builder.append(" ESCAPE ").append((String)this.process((Node)escape, context)));
            builder.append(')');
            return builder.toString();
        }

        @Override
        protected String visitAllColumns(AllColumns node, Void context) {
            if (node.getPrefix().isPresent()) {
                return node.getPrefix().get() + ".*";
            }
            return "*";
        }

        @Override
        public String visitCast(Cast node, Void context) {
            return (node.isSafe() ? "TRY_CAST" : "CAST") + "(" + (String)this.process(node.getExpression(), context) + " AS " + node.getType() + ")";
        }

        @Override
        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, context));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Node)value, context)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add(this.process(node.getOperand(), context));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, context));
            }
            node.getDefaultValue().ifPresent(value -> parts.add((Object)"ELSE").add(this.process((Node)value, context)));
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitWhenClause(WhenClause node, Void context) {
            return "WHEN " + (String)this.process(node.getOperand(), context) + " THEN " + (String)this.process(node.getResult(), context);
        }

        @Override
        protected String visitBetweenPredicate(BetweenPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " BETWEEN " + (String)this.process(node.getMin(), context) + " AND " + (String)this.process(node.getMax(), context) + ")";
        }

        @Override
        protected String visitInPredicate(InPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IN " + (String)this.process(node.getValueList(), context) + ")";
        }

        @Override
        protected String visitInListExpression(InListExpression node, Void context) {
            return "(" + this.joinExpressions(node.getValues()) + ")";
        }

        private String visitFilter(Expression node, Void context) {
            return "(WHERE " + (String)this.process(node, context) + ')';
        }

        @Override
        public String visitWindow(Window node, Void context) {
            ArrayList<String> parts = new ArrayList<String>();
            if (!node.getPartitionBy().isEmpty()) {
                parts.add("PARTITION BY " + this.joinExpressions(node.getPartitionBy()));
            }
            if (node.getOrderBy().isPresent()) {
                parts.add(ExpressionFormatter.formatOrderBy(node.getOrderBy().get(), this.parameters));
            }
            if (node.getFrame().isPresent()) {
                parts.add((String)this.process(node.getFrame().get(), context));
            }
            return '(' + Joiner.on((char)' ').join(parts) + ')';
        }

        @Override
        public String visitWindowFrame(WindowFrame node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString()).append(' ');
            if (node.getEnd().isPresent()) {
                builder.append("BETWEEN ").append((String)this.process(node.getStart(), context)).append(" AND ").append((String)this.process(node.getEnd().get(), context));
            } else {
                builder.append((String)this.process(node.getStart(), context));
            }
            return builder.toString();
        }

        @Override
        public String visitFrameBound(FrameBound node, Void context) {
            switch (node.getType()) {
                case UNBOUNDED_PRECEDING: {
                    return "UNBOUNDED PRECEDING";
                }
                case PRECEDING: {
                    return (String)this.process(node.getValue().get(), context) + " PRECEDING";
                }
                case CURRENT_ROW: {
                    return "CURRENT ROW";
                }
                case FOLLOWING: {
                    return (String)this.process(node.getValue().get(), context) + " FOLLOWING";
                }
                case UNBOUNDED_FOLLOWING: {
                    return "UNBOUNDED FOLLOWING";
                }
            }
            throw new IllegalArgumentException("unhandled type: " + (Object)((Object)node.getType()));
        }

        @Override
        protected String visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + ' ' + node.getOperator().getValue() + ' ' + node.getQuantifier().toString() + ' ' + (String)this.process(node.getSubquery(), context) + ")";
        }

        @Override
        public String visitGroupingOperation(GroupingOperation node, Void context) {
            return "GROUPING (" + this.joinExpressions(node.getGroupingColumns()) + ")";
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right) {
            return '(' + (String)this.process(left, null) + ' ' + operator + ' ' + (String)this.process(right, null) + ')';
        }

        private String joinExpressions(List<Expression> expressions) {
            return Joiner.on((String)", ").join(expressions.stream().map(e -> (String)this.process((Node)e, null)).iterator());
        }

        @Override
        protected String visitTableVersion(TableVersionExpression node, Void context) {
            return "FOR " + node.getTableVersionType().name() + " AS OF " + (String)this.process(node.getAsOfExpression(), context) + " ";
        }
    }
}

