/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ConstraintSpecification;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class AddConstraint
extends Statement {
    private final QualifiedName tableName;
    private final boolean tableExists;
    private final ConstraintSpecification constraintSpecification;

    public AddConstraint(QualifiedName tableName, boolean tableExists, ConstraintSpecification constraintSpecification) {
        this(Optional.empty(), tableName, tableExists, constraintSpecification);
    }

    public AddConstraint(NodeLocation location, QualifiedName tableName, boolean tableExists, ConstraintSpecification constraintSpecification) {
        this(Optional.of(location), tableName, tableExists, constraintSpecification);
    }

    private AddConstraint(Optional<NodeLocation> location, QualifiedName tableName, boolean tableExists, ConstraintSpecification constraintSpecification) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.tableExists = tableExists;
        this.constraintSpecification = constraintSpecification;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public ConstraintSpecification getConstraintSpecification() {
        return this.constraintSpecification;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddConstraint(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.constraintSpecification);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddConstraint o = (AddConstraint)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.constraintSpecification, o.constraintSpecification);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("constraintSpecification", (Object)this.constraintSpecification).toString();
    }
}

