/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableVersionExpression
extends Expression {
    private final Expression asOfExpression;
    private final TableVersionType type;

    public TableVersionExpression(TableVersionType type, Expression value) {
        this(Optional.empty(), type, value);
    }

    public TableVersionExpression(NodeLocation location, TableVersionType type, Expression value) {
        this(Optional.of(location), type, value);
    }

    private TableVersionExpression(Optional<NodeLocation> location, TableVersionType type, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(type, "type is null");
        this.asOfExpression = value;
        this.type = type;
    }

    public static TableVersionExpression timestampExpression(NodeLocation location, Expression value) {
        return new TableVersionExpression(Optional.of(location), TableVersionType.TIMESTAMP, value);
    }

    public static TableVersionExpression versionExpression(NodeLocation location, Expression value) {
        return new TableVersionExpression(Optional.of(location), TableVersionType.VERSION, value);
    }

    public static TableVersionExpression timestampExpression(Expression value) {
        return new TableVersionExpression(Optional.empty(), TableVersionType.TIMESTAMP, value);
    }

    public static TableVersionExpression versionExpression(Expression value) {
        return new TableVersionExpression(Optional.empty(), TableVersionType.VERSION, value);
    }

    public Expression getAsOfExpression() {
        return this.asOfExpression;
    }

    public TableVersionType getTableVersionType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableVersion(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.asOfExpression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableVersionExpression that = (TableVersionExpression)o;
        return Objects.equals(this.asOfExpression, that.asOfExpression) && this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.asOfExpression, this.type});
    }

    public static enum TableVersionType {
        TIMESTAMP,
        VERSION;

    }
}

