/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableVersionExpression
extends Expression {
    private final Expression stateExpression;
    private final TableVersionType type;
    private final TableVersionOperator operator;

    public TableVersionExpression(TableVersionType type, TableVersionOperator operator, Expression value) {
        this(Optional.empty(), type, operator, value);
    }

    public TableVersionExpression(NodeLocation location, TableVersionType type, TableVersionOperator operator, Expression value) {
        this(Optional.of(location), type, operator, value);
    }

    private TableVersionExpression(Optional<NodeLocation> location, TableVersionType type, TableVersionOperator operator, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(type, "type is null");
        this.stateExpression = value;
        this.operator = operator;
        this.type = type;
    }

    public static TableVersionExpression timestampExpression(NodeLocation location, TableVersionOperator operator, Expression value) {
        return new TableVersionExpression(Optional.of(location), TableVersionType.TIMESTAMP, operator, value);
    }

    public static TableVersionExpression versionExpression(NodeLocation location, TableVersionOperator operator, Expression value) {
        return new TableVersionExpression(Optional.of(location), TableVersionType.VERSION, operator, value);
    }

    public static TableVersionExpression timestampExpression(TableVersionOperator operator, Expression value) {
        return new TableVersionExpression(Optional.empty(), TableVersionType.TIMESTAMP, operator, value);
    }

    public static TableVersionExpression versionExpression(TableVersionOperator operator, Expression value) {
        return new TableVersionExpression(Optional.empty(), TableVersionType.VERSION, operator, value);
    }

    public Expression getStateExpression() {
        return this.stateExpression;
    }

    public TableVersionType getTableVersionType() {
        return this.type;
    }

    public TableVersionOperator getTableVersionOperator() {
        return this.operator;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableVersion(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.stateExpression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableVersionExpression that = (TableVersionExpression)o;
        return Objects.equals(this.stateExpression, that.stateExpression) && this.type == that.type && this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.stateExpression, this.type, this.operator});
    }

    public static enum TableVersionOperator {
        EQUAL,
        LESS_THAN;

    }

    public static enum TableVersionType {
        TIMESTAMP,
        VERSION;

    }
}

