/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.IdentityHashMap;
import java.util.List;

public class TreePrinter {
    private static final String INDENT = "   ";
    private final IdentityHashMap<Expression, QualifiedName> resolvedNameReferences;
    private final PrintStream out;

    public TreePrinter(IdentityHashMap<Expression, QualifiedName> resolvedNameReferences, PrintStream out) {
        this.resolvedNameReferences = new IdentityHashMap<Expression, QualifiedName>(resolvedNameReferences);
        this.out = out;
    }

    public void print(Node root) {
        DefaultTraversalVisitor<Void, Integer> printer = new DefaultTraversalVisitor<Void, Integer>(){

            @Override
            protected Void visitNode(Node node, Integer indentLevel) {
                throw new UnsupportedOperationException("not yet implemented: " + node);
            }

            @Override
            protected Void visitQuery(Query node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Query ");
                Integer n = indentLevel;
                indentLevel = indentLevel + 1;
                TreePrinter.this.print(indentLevel, "QueryBody");
                this.process(node.getQueryBody(), indentLevel);
                if (node.getOrderBy().isPresent()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    this.process(node.getOrderBy().get(), indentLevel + 1);
                }
                if (node.getLimit().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Limit: " + node.getLimit().get());
                }
                return null;
            }

            @Override
            protected Void visitQuerySpecification(QuerySpecification node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "QuerySpecification ");
                Integer n = indentLevel;
                indentLevel = indentLevel + 1;
                this.process(node.getSelect(), indentLevel);
                if (node.getFrom().isPresent()) {
                    TreePrinter.this.print(indentLevel, "From");
                    this.process(node.getFrom().get(), indentLevel + 1);
                }
                if (node.getWhere().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Where");
                    this.process(node.getWhere().get(), indentLevel + 1);
                }
                if (node.getGroupBy().isPresent()) {
                    String distinct = "";
                    if (node.getGroupBy().get().isDistinct()) {
                        distinct = "[DISTINCT]";
                    }
                    TreePrinter.this.print(indentLevel, "GroupBy" + distinct);
                    for (GroupingElement groupingElement : node.getGroupBy().get().getGroupingElements()) {
                        TreePrinter.this.print(indentLevel, "SimpleGroupBy");
                        if (groupingElement instanceof SimpleGroupBy) {
                            for (Expression expression : groupingElement.getExpressions()) {
                                this.process(expression, indentLevel + 1);
                            }
                            continue;
                        }
                        if (groupingElement instanceof GroupingSets) {
                            TreePrinter.this.print(indentLevel + 1, "GroupingSets");
                            for (List list : ((GroupingSets)groupingElement).getSets()) {
                                TreePrinter.this.print(indentLevel + 2, "GroupingSet[");
                                for (Expression expression : list) {
                                    this.process(expression, indentLevel + 3);
                                }
                                TreePrinter.this.print(indentLevel + 2, "]");
                            }
                            continue;
                        }
                        if (groupingElement instanceof Cube) {
                            TreePrinter.this.print(indentLevel + 1, "Cube");
                            for (Expression expression : groupingElement.getExpressions()) {
                                this.process(expression, indentLevel + 1);
                            }
                            continue;
                        }
                        if (!(groupingElement instanceof Rollup)) continue;
                        TreePrinter.this.print(indentLevel + 1, "Rollup");
                        for (Expression expression : groupingElement.getExpressions()) {
                            this.process(expression, indentLevel + 1);
                        }
                    }
                }
                if (node.getHaving().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Having");
                    this.process(node.getHaving().get(), indentLevel + 1);
                }
                if (node.getOrderBy().isPresent()) {
                    TreePrinter.this.print(indentLevel, "OrderBy");
                    this.process(node.getOrderBy().get(), indentLevel + 1);
                }
                if (node.getLimit().isPresent()) {
                    TreePrinter.this.print(indentLevel, "Limit: " + node.getLimit().get());
                }
                return null;
            }

            @Override
            protected Void visitOrderBy(OrderBy node, Integer indentLevel) {
                for (SortItem sortItem : node.getSortItems()) {
                    this.process(sortItem, indentLevel);
                }
                return null;
            }

            @Override
            protected Void visitSelect(Select node, Integer indentLevel) {
                String distinct = "";
                if (node.isDistinct()) {
                    distinct = "[DISTINCT]";
                }
                TreePrinter.this.print(indentLevel, "Select" + distinct);
                super.visitSelect(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitAllColumns(AllColumns node, Integer indent) {
                if (node.getPrefix().isPresent()) {
                    TreePrinter.this.print(indent, node.getPrefix() + ".*");
                } else {
                    TreePrinter.this.print(indent, "*");
                }
                return null;
            }

            @Override
            protected Void visitSingleColumn(SingleColumn node, Integer indent) {
                if (node.getAlias().isPresent()) {
                    TreePrinter.this.print(indent, "Alias: " + node.getAlias().get());
                }
                super.visitSingleColumn(node, indent + 1);
                return null;
            }

            @Override
            protected Void visitComparisonExpression(ComparisonExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getOperator().toString());
                super.visitComparisonExpression(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getOperator().toString());
                super.visitArithmeticBinary(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, node.getOperator().toString());
                super.visitLogicalBinaryExpression(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitStringLiteral(StringLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "String[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitBinaryLiteral(BinaryLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Binary[" + node.toHexString() + "]");
                return null;
            }

            @Override
            protected Void visitBooleanLiteral(BooleanLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Boolean[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitLongLiteral(LongLiteral node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Long[" + node.getValue() + "]");
                return null;
            }

            @Override
            protected Void visitLikePredicate(LikePredicate node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "LIKE");
                super.visitLikePredicate(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitIdentifier(Identifier node, Integer indentLevel) {
                QualifiedName resolved = (QualifiedName)TreePrinter.this.resolvedNameReferences.get(node);
                String resolvedName = "";
                if (resolved != null) {
                    resolvedName = "=>" + resolved.toString();
                }
                TreePrinter.this.print(indentLevel, "Identifier[" + node.getValue() + resolvedName + "]");
                return null;
            }

            @Override
            protected Void visitDereferenceExpression(DereferenceExpression node, Integer indentLevel) {
                QualifiedName resolved = (QualifiedName)TreePrinter.this.resolvedNameReferences.get(node);
                String resolvedName = "";
                if (resolved != null) {
                    resolvedName = "=>" + resolved.toString();
                }
                TreePrinter.this.print(indentLevel, "DereferenceExpression[" + node + resolvedName + "]");
                return null;
            }

            @Override
            protected Void visitFunctionCall(FunctionCall node, Integer indentLevel) {
                String name = Joiner.on((char)'.').join(node.getName().getParts());
                TreePrinter.this.print(indentLevel, "FunctionCall[" + name + "]");
                super.visitFunctionCall(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitTable(Table node, Integer indentLevel) {
                String name = Joiner.on((char)'.').join(node.getName().getParts());
                TreePrinter.this.print(indentLevel, "Table[" + name + "]");
                return null;
            }

            @Override
            protected Void visitValues(Values node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Values");
                super.visitValues(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitRow(Row node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Row");
                super.visitRow(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitAliasedRelation(AliasedRelation node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "Alias[" + node.getAlias() + "]");
                super.visitAliasedRelation(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitSampledRelation(SampledRelation node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "TABLESAMPLE[" + (Object)((Object)node.getType()) + " (" + node.getSamplePercentage() + ")]");
                super.visitSampledRelation(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitTableSubquery(TableSubquery node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "SubQuery");
                super.visitTableSubquery(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitInPredicate(InPredicate node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "IN");
                super.visitInPredicate(node, indentLevel + 1);
                return null;
            }

            @Override
            protected Void visitSubqueryExpression(SubqueryExpression node, Integer indentLevel) {
                TreePrinter.this.print(indentLevel, "SubQuery");
                super.visitSubqueryExpression(node, indentLevel + 1);
                return null;
            }
        };
        printer.process(root, 0);
    }

    private void print(Integer indentLevel, String value) {
        this.out.println(Strings.repeat((String)INDENT, (int)indentLevel) + value);
    }
}

