/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.http.client.Request;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotUtils;
import com.facebook.presto.pinot.auth.PinotBrokerAuthenticationProvider;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pinot.spi.utils.BytesUtils;

public class PinotBrokerPageSource
implements ConnectorPageSource {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final List<Class> SUPPORTED_PRESTO_COLUMN_TYPE_CLASSES = ImmutableList.of(FixedWidthType.class, VarcharType.class, JsonType.class, VarbinaryType.class);
    private static final String REQUEST_PAYLOAD_KEY = "sql";
    private static final String QUERY_URL_TEMPLATE = "%s://%s/query/sql";
    private final PinotQueryGenerator.GeneratedPinotQuery brokerSql;
    private final List<PinotColumnHandle> expectedHandles;
    protected final PinotConfig pinotConfig;
    protected final List<PinotColumnHandle> columnHandles;
    protected final PinotClusterInfoFetcher clusterInfoFetcher;
    protected final ConnectorSession session;
    protected final ObjectMapper objectMapper;
    protected final PinotBrokerAuthenticationProvider brokerAuthenticationProvider;
    protected boolean finished;
    protected long readTimeNanos;
    protected long completedBytes;

    public PinotBrokerPageSource(PinotConfig pinotConfig, ConnectorSession session, PinotQueryGenerator.GeneratedPinotQuery brokerSql, List<PinotColumnHandle> columnHandles, List<PinotColumnHandle> expectedHandles, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper, PinotBrokerAuthenticationProvider brokerAuthenticationProvider) {
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinot config is null");
        this.clusterInfoFetcher = Objects.requireNonNull(clusterInfoFetcher, "cluster info fetcher is null");
        this.columnHandles = ImmutableList.copyOf(columnHandles);
        this.session = Objects.requireNonNull(session, "session is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper is null");
        this.brokerAuthenticationProvider = brokerAuthenticationProvider;
        this.expectedHandles = Objects.requireNonNull(expectedHandles, "expected handles is null");
        this.brokerSql = Objects.requireNonNull(brokerSql, "broker is null");
    }

    protected void setValue(Type type, BlockBuilder blockBuilder, JsonNode value) {
        if (blockBuilder == null) {
            return;
        }
        if (value == null || value.isNull()) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkState((boolean)value.isArray());
            BlockBuilder childBuilder = blockBuilder.beginBlockEntry();
            ArrayNode arrayNode = (ArrayNode)value;
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.setValue(((ArrayType)type).getElementType(), childBuilder, PinotBrokerPageSource.asText(arrayNode.get(i)));
            }
            blockBuilder.closeEntry();
        } else {
            this.setValue(type, blockBuilder, PinotBrokerPageSource.asText(value));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setValue(Type type, BlockBuilder blockBuilder, String value) {
        if (blockBuilder == null) {
            return;
        }
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (!this.isTypeSupportInPinot(type)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
        }
        if (type instanceof FixedWidthType) {
            this.completedBytes += (long)((FixedWidthType)type).getFixedSize();
            if (type instanceof BigintType) {
                type.writeLong(blockBuilder, PinotUtils.parseDouble(value).longValue());
                return;
            } else if (type instanceof IntegerType) {
                blockBuilder.writeInt(PinotUtils.parseDouble(value).intValue());
                return;
            } else if (type instanceof TinyintType) {
                blockBuilder.writeByte((int)PinotUtils.parseDouble(value).byteValue());
                return;
            } else if (type instanceof SmallintType) {
                blockBuilder.writeShort((int)PinotUtils.parseDouble(value).shortValue());
                return;
            } else if (type instanceof BooleanType) {
                type.writeBoolean(blockBuilder, Boolean.parseBoolean(value));
                return;
            } else if (type instanceof DecimalType || type instanceof DoubleType) {
                type.writeDouble(blockBuilder, PinotUtils.parseDouble(value).doubleValue());
                return;
            } else if (type instanceof TimestampType) {
                type.writeLong(blockBuilder, PinotUtils.parseTimestamp(value));
                return;
            } else {
                if (!(type instanceof DateType)) throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + type + "' not supported");
                type.writeLong(blockBuilder, Long.parseLong(value));
            }
            return;
        } else if (type instanceof VarbinaryType) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])BytesUtils.toBytes((String)value)));
            return;
        } else {
            Slice slice = Slices.utf8Slice((String)value);
            blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
            this.completedBytes += (long)slice.length();
        }
    }

    private boolean isTypeSupportInPinot(Type type) {
        for (Class clazz : SUPPORTED_PRESTO_COLUMN_TYPE_CLASSES) {
            if (!clazz.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        long start = System.nanoTime();
        try {
            BlockAndTypeBuilder blockAndTypeBuilder = this.buildBlockAndTypeBuilder(this.columnHandles, this.brokerSql);
            int counter = this.issueQueryAndPopulate(this.brokerSql, Collections.unmodifiableList(blockAndTypeBuilder.getColumnBlockBuilders()), Collections.unmodifiableList(blockAndTypeBuilder.getColumnTypes()));
            PageBuilder pageBuilder = blockAndTypeBuilder.getPageBuilder();
            pageBuilder.declarePositions(counter);
            Page page = pageBuilder.build();
            this.finished = true;
            Page page2 = page;
            return page2;
        }
        finally {
            this.readTimeNanos += System.nanoTime() - start;
        }
    }

    protected void setRows(String query, List<BlockBuilder> blockBuilders, List<Type> types, JsonNode rows) {
        for (int rowNumber = 0; rowNumber < rows.size(); ++rowNumber) {
            JsonNode result = rows.get(rowNumber);
            if (result == null || result.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(query), String.format("Expected row of %d columns", blockBuilders.size()));
            }
            for (int columnNumber = 0; columnNumber < blockBuilders.size(); ++columnNumber) {
                this.setValue(types.get(columnNumber), blockBuilders.get(columnNumber), result.get(columnNumber));
            }
        }
    }

    protected static void handleCommonResponse(String pinotQuery, JsonNode jsonBody) {
        JsonNode numServersResponded = jsonBody.get("numServersResponded");
        JsonNode numServersQueried = jsonBody.get("numServersQueried");
        if (numServersQueried == null || numServersResponded == null || numServersQueried.asInt() > numServersResponded.asInt()) {
            throw new PinotException(PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, Optional.of(pinotQuery), String.format("Only %s out of %s servers responded for query %s", numServersResponded.asInt(), numServersQueried.asInt(), pinotQuery));
        }
        JsonNode exceptions = jsonBody.get("exceptions");
        if (exceptions != null && exceptions.isArray() && exceptions.size() > 0) {
            if (exceptions.get(0).get("errorCode").asInt() == 180) {
                throw new PinotException(PinotErrorCode.PINOT_UNAUTHENTICATED_EXCEPTION, Optional.empty(), "Query authentication failed.");
            }
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(pinotQuery), String.format("Query %s encountered exception %s", pinotQuery, exceptions.get(0)));
        }
    }

    protected static String asText(JsonNode node) {
        if (node.isArray()) {
            Object[] results = new String[node.size()];
            for (int i = 0; i < node.size(); ++i) {
                results[i] = PinotBrokerPageSource.asText(node.get(i));
            }
            return Arrays.toString(results);
        }
        Preconditions.checkState((boolean)node.isValueNode());
        return node.isNull() ? null : node.asText();
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.finished = true;
    }

    protected int issueQueryAndPopulate(PinotQueryGenerator.GeneratedPinotQuery pinotQuery, List<BlockBuilder> blockBuilders, List<Type> types) {
        return PinotUtils.doWithRetries(PinotSessionProperties.getPinotRetryCount(this.session), retryNumber -> {
            Optional<String> rpcService;
            String queryHost;
            if (this.pinotConfig.isUseProxy()) {
                queryHost = this.pinotConfig.getControllerUrl();
                rpcService = Optional.ofNullable(this.pinotConfig.getRestProxyServiceForQuery());
            } else {
                queryHost = this.clusterInfoFetcher.getBrokerHost(pinotQuery.getTable());
                rpcService = Optional.empty();
            }
            Request.Builder builder = Request.Builder.preparePost().setUri(URI.create(String.format(QUERY_URL_TEMPLATE, this.pinotConfig.isUseSecureConnection() ? "https" : "http", queryHost)));
            this.brokerAuthenticationProvider.getAuthenticationToken(this.session).ifPresent(token -> builder.setHeader("Authorization", token));
            String body = this.clusterInfoFetcher.doHttpActionWithHeaders(builder, Optional.of(PinotBrokerPageSource.getRequestPayload(pinotQuery)), rpcService);
            return this.populateFromQueryResults(pinotQuery, blockBuilders, types, body);
        });
    }

    public static String getRequestPayload(PinotQueryGenerator.GeneratedPinotQuery pinotQuery) {
        ImmutableMap pinotRequest = ImmutableMap.of((Object)REQUEST_PAYLOAD_KEY, (Object)pinotQuery.getQuery());
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)pinotRequest);
        }
        catch (JsonProcessingException e) {
            throw new PinotException(PinotErrorCode.PINOT_REQUEST_GENERATOR_FAILURE, Optional.of(pinotQuery.getQuery()), "Unable to Jsonify request: " + Arrays.toString(pinotRequest.entrySet().toArray()), e);
        }
    }

    @VisibleForTesting
    public int populateFromQueryResults(PinotQueryGenerator.GeneratedPinotQuery pinotQuery, List<BlockBuilder> blockBuilders, List<Type> types, String responseJsonString) {
        JsonNode jsonBody;
        String sql = pinotQuery.getQuery();
        try {
            jsonBody = this.objectMapper.readTree(responseJsonString);
        }
        catch (IOException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), "Couldn't parse response", e);
        }
        PinotBrokerPageSource.handleCommonResponse(sql, jsonBody);
        JsonNode resultTable = jsonBody.get("resultTable");
        if (resultTable != null) {
            JsonNode dataSchema = resultTable.get("dataSchema");
            if (dataSchema == null) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("Expected data schema in the response", new Object[0]));
            }
            JsonNode columnDataTypes = dataSchema.get("columnDataTypes");
            JsonNode columnNames = dataSchema.get("columnNames");
            if (columnDataTypes == null || !columnDataTypes.isArray() || columnDataTypes.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("ColumnDataTypes and results expected for %s, expected %d columnDataTypes but got %d", sql, blockBuilders.size(), columnDataTypes == null ? 0 : columnDataTypes.size()));
            }
            if (columnNames == null || !columnNames.isArray() || columnNames.size() < blockBuilders.size()) {
                throw new PinotException(PinotErrorCode.PINOT_UNEXPECTED_RESPONSE, Optional.of(sql), String.format("ColumnNames and results expected for %s, expected %d columnNames but got %d", sql, blockBuilders.size(), columnNames == null ? 0 : columnNames.size()));
            }
            JsonNode rows = resultTable.get("rows");
            this.setRows(sql, blockBuilders, types, rows);
            return rows.size();
        }
        return 0;
    }

    @VisibleForTesting
    public BlockAndTypeBuilder buildBlockAndTypeBuilder(List<PinotColumnHandle> columnHandles, PinotQueryGenerator.GeneratedPinotQuery brokerSql) {
        List expectedTypes = columnHandles.stream().map(PinotColumnHandle::getDataType).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(expectedTypes);
        int[] handleMapping = new int[this.expectedHandles.size()];
        for (int i = 0; i < handleMapping.length; ++i) {
            handleMapping[i] = columnHandles.indexOf(this.expectedHandles.get(i));
        }
        ArrayList<BlockBuilder> columnBlockBuilders = new ArrayList<BlockBuilder>();
        ArrayList<Type> columnTypes = new ArrayList<Type>();
        for (int expectedColumnIndex : brokerSql.getExpectedColumnIndices()) {
            int columnIndex = -1;
            if (expectedColumnIndex >= 0) {
                columnIndex = handleMapping[expectedColumnIndex];
            }
            columnBlockBuilders.add(columnIndex >= 0 ? pageBuilder.getBlockBuilder(columnIndex) : null);
            columnTypes.add(columnIndex >= 0 ? (Type)expectedTypes.get(columnIndex) : null);
        }
        return new BlockAndTypeBuilder(pageBuilder, columnBlockBuilders, columnTypes);
    }

    public static class BlockAndTypeBuilder {
        private final PageBuilder pageBuilder;
        private final List<BlockBuilder> columnBlockBuilders;
        private final List<Type> columnTypes;

        public BlockAndTypeBuilder(PageBuilder pageBuilder, List<BlockBuilder> columnBlockBuilders, List<Type> columnTypes) {
            this.pageBuilder = pageBuilder;
            this.columnBlockBuilders = columnBlockBuilders;
            this.columnTypes = columnTypes;
        }

        public PageBuilder getPageBuilder() {
            return this.pageBuilder;
        }

        public List<BlockBuilder> getColumnBlockBuilders() {
            return this.columnBlockBuilders;
        }

        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }
    }
}

