/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigSecuritySensitive;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class PinotConfig {
    public static final int DEFAULT_LIMIT_LARGE_FOR_SEGMENT = Integer.MAX_VALUE;
    public static final int DEFAULT_NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES = 25000;
    public static final int DEFAULT_STREAMING_SERVER_GRPC_MAX_INBOUND_MESSAGE_BYTES = (int)new DataSize(128.0, DataSize.Unit.MEGABYTE).toBytes();
    public static final int DEFAULT_TOPN_LARGE = 10000;
    public static final int DEFAULT_PROXY_GRPC_PORT = 8124;
    public static final String DEFAULT_GRPC_TLS_STORE_TYPE = "PKCS12";
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = new Duration(1.0, TimeUnit.MINUTES);
    private static final int DEFAULT_ESTIMATED_SIZE_IN_BYTES_FOR_NON_NUMERIC_COLUMN = 20;
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator(":");
    private String controllerRestService;
    private String serviceHeaderParam = "RPC-Service";
    private String callerHeaderValue = "presto";
    private String callerHeaderParam = "RPC-Caller";
    private List<String> controllerUrls = ImmutableList.of();
    private String restProxyServiceForQuery;
    private int limitLargeForSegment = Integer.MAX_VALUE;
    private int topNLarge = 10000;
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private int estimatedSizeInBytesForNonNumericColumn = 20;
    private Map<String, String> extraHttpHeaders = ImmutableMap.of();
    private Duration metadataCacheExpiry = new Duration(2.0, TimeUnit.MINUTES);
    private boolean forbidBrokerQueries;
    private boolean forbidSegmentQueries;
    private boolean attemptBrokerQueries;
    private boolean inferDateTypeInSchema = true;
    private boolean inferTimestampTypeInSchema = true;
    private boolean markDataFetchExceptionsAsRetriable = true;
    private int streamingServerGrpcMaxInboundMessageBytes = DEFAULT_STREAMING_SERVER_GRPC_MAX_INBOUND_MESSAGE_BYTES;
    private int numSegmentsPerSplit = 1;
    private boolean ignoreEmptyResponses;
    private int fetchRetryCount = 2;
    private boolean useDateTrunc;
    private int nonAggregateLimitForBrokerQueries = 25000;
    private boolean pushdownTopNBrokerQueries = true;
    private boolean pushdownProjectExpressions = true;
    private String grpcHost;
    private int grpcPort = 8124;
    private boolean useProxy;
    private boolean useSecureConnection;
    private Map<String, String> extraGrpcMetadata = ImmutableMap.of();
    private String overrideDistinctCountFunction = "distinctCount";
    private String grpcTlsKeyStorePath;
    private String grpcTlsKeyStorePassword;
    private String grpcTlsKeyStoreType = "PKCS12";
    private String grpcTlsTrustStorePath;
    private String grpcTlsTrustStorePassword;
    private String grpcTlsTrustStoreType = "PKCS12";
    private String controllerAuthenticationType = "NONE";
    private String controllerAuthenticationUser;
    private String controllerAuthenticationPassword;
    private String brokerAuthenticationType = "NONE";
    private String brokerAuthenticationUser;
    private String brokerAuthenticationPassword;
    private String queryOptions;

    @NotNull
    public Map<String, String> getExtraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Config(value="pinot.extra-http-headers")
    public PinotConfig setExtraHttpHeaders(String headers) {
        this.extraHttpHeaders = ImmutableMap.copyOf((Map)MAP_SPLITTER.split((CharSequence)headers));
        return this;
    }

    @NotNull
    public Map<String, String> getExtraGrpcMetadata() {
        return this.extraGrpcMetadata;
    }

    @Config(value="pinot.extra-grpc-metadata")
    public PinotConfig setExtraGrpcMetadata(String metadata) {
        this.extraGrpcMetadata = ImmutableMap.copyOf((Map)MAP_SPLITTER.split((CharSequence)metadata));
        return this;
    }

    @NotNull
    public List<String> getControllerUrls() {
        return this.controllerUrls;
    }

    @Config(value="pinot.controller-urls")
    public PinotConfig setControllerUrls(String controllerUrl) {
        this.controllerUrls = LIST_SPLITTER.splitToList((CharSequence)controllerUrl);
        return this;
    }

    @Nullable
    public String getControllerRestService() {
        return this.controllerRestService;
    }

    @Config(value="pinot.controller-rest-service")
    public PinotConfig setControllerRestService(String controllerRestService) {
        this.controllerRestService = controllerRestService;
        return this;
    }

    @NotNull
    public int getLimitLargeForSegment() {
        return this.limitLargeForSegment;
    }

    @Config(value="pinot.limit-large-for-segment")
    public PinotConfig setLimitLargeForSegment(int limitLargeForSegment) {
        this.limitLargeForSegment = limitLargeForSegment;
        return this;
    }

    @NotNull
    public int getTopNLarge() {
        return this.topNLarge;
    }

    @Config(value="pinot.topn-large")
    public PinotConfig setTopNLarge(int topNLarge) {
        this.topNLarge = topNLarge;
        return this;
    }

    @MinDuration(value="0s")
    @NotNull
    public Duration getMetadataCacheExpiry() {
        return this.metadataCacheExpiry;
    }

    @Config(value="pinot.metadata-expiry")
    public PinotConfig setMetadataCacheExpiry(Duration metadataCacheExpiry) {
        this.metadataCacheExpiry = metadataCacheExpiry;
        return this;
    }

    @NotNull
    public int getEstimatedSizeInBytesForNonNumericColumn() {
        return this.estimatedSizeInBytesForNonNumericColumn;
    }

    @Config(value="pinot.estimated-size-in-bytes-for-non-numeric-column")
    public PinotConfig setEstimatedSizeInBytesForNonNumericColumn(int estimatedSizeInBytesForNonNumericColumn) {
        this.estimatedSizeInBytesForNonNumericColumn = estimatedSizeInBytesForNonNumericColumn;
        return this;
    }

    @NotNull
    public String getServiceHeaderParam() {
        return this.serviceHeaderParam;
    }

    @Config(value="pinot.service-header-param")
    public PinotConfig setServiceHeaderParam(String serviceHeaderParam) {
        this.serviceHeaderParam = serviceHeaderParam;
        return this;
    }

    @NotNull
    public String getCallerHeaderValue() {
        return this.callerHeaderValue;
    }

    @Config(value="pinot.caller-header-value")
    public PinotConfig setCallerHeaderValue(String callerHeaderValue) {
        this.callerHeaderValue = callerHeaderValue;
        return this;
    }

    @NotNull
    public String getCallerHeaderParam() {
        return this.callerHeaderParam;
    }

    @Config(value="pinot.caller-header-param")
    public PinotConfig setCallerHeaderParam(String callerHeaderParam) {
        this.callerHeaderParam = callerHeaderParam;
        return this;
    }

    public boolean isForbidBrokerQueries() {
        return this.forbidBrokerQueries;
    }

    @Config(value="pinot.forbid-broker-queries")
    public PinotConfig setForbidBrokerQueries(boolean forbidBrokerQueries) {
        this.forbidBrokerQueries = forbidBrokerQueries;
        return this;
    }

    public boolean isForbidSegmentQueries() {
        return this.forbidSegmentQueries;
    }

    @Config(value="pinot.forbid-segment-queries")
    public PinotConfig setForbidSegmentQueries(boolean forbidSegmentQueries) {
        this.forbidSegmentQueries = forbidSegmentQueries;
        return this;
    }

    public boolean isAttemptBrokerQueries() {
        return this.attemptBrokerQueries;
    }

    @Config(value="pinot.attempt-broker-queries")
    public PinotConfig setAttemptBrokerQueries(boolean attemptBrokerQueries) {
        this.attemptBrokerQueries = attemptBrokerQueries;
        return this;
    }

    @Nullable
    public String getRestProxyServiceForQuery() {
        return this.restProxyServiceForQuery;
    }

    @Config(value="pinot.rest-proxy-service-for-query")
    public PinotConfig setRestProxyServiceForQuery(String restProxyServiceForQuery) {
        this.restProxyServiceForQuery = restProxyServiceForQuery;
        return this;
    }

    public boolean isUseDateTrunc() {
        return this.useDateTrunc;
    }

    @Config(value="pinot.use-date-trunc")
    public PinotConfig setUseDateTrunc(boolean useDateTrunc) {
        this.useDateTrunc = useDateTrunc;
        return this;
    }

    public int getNumSegmentsPerSplit() {
        return this.numSegmentsPerSplit;
    }

    @Config(value="pinot.num-segments-per-split")
    public PinotConfig setNumSegmentsPerSplit(int numSegmentsPerSplit) {
        Preconditions.checkArgument((numSegmentsPerSplit > 0 ? 1 : 0) != 0, (Object)"Number of segments per split must be more than zero");
        this.numSegmentsPerSplit = numSegmentsPerSplit;
        return this;
    }

    public int getFetchRetryCount() {
        return this.fetchRetryCount;
    }

    @Config(value="pinot.fetch-retry-count")
    public PinotConfig setFetchRetryCount(int fetchRetryCount) {
        this.fetchRetryCount = fetchRetryCount;
        return this;
    }

    public int getNonAggregateLimitForBrokerQueries() {
        return this.nonAggregateLimitForBrokerQueries;
    }

    @Config(value="pinot.non-aggregate-limit-for-broker-queries")
    public PinotConfig setNonAggregateLimitForBrokerQueries(int nonAggregateLimitForBrokerQueries) {
        this.nonAggregateLimitForBrokerQueries = nonAggregateLimitForBrokerQueries;
        return this;
    }

    public boolean isInferDateTypeInSchema() {
        return this.inferDateTypeInSchema;
    }

    @Config(value="pinot.infer-date-type-in-schema")
    public PinotConfig setInferDateTypeInSchema(boolean inferDateTypeInSchema) {
        this.inferDateTypeInSchema = inferDateTypeInSchema;
        return this;
    }

    public boolean isInferTimestampTypeInSchema() {
        return this.inferTimestampTypeInSchema;
    }

    @Config(value="pinot.infer-timestamp-type-in-schema")
    public PinotConfig setInferTimestampTypeInSchema(boolean inferTimestampTypeInSchema) {
        this.inferTimestampTypeInSchema = inferTimestampTypeInSchema;
        return this;
    }

    public boolean isMarkDataFetchExceptionsAsRetriable() {
        return this.markDataFetchExceptionsAsRetriable;
    }

    @Config(value="pinot.mark-data-fetch-exceptions-as-retriable")
    public PinotConfig setMarkDataFetchExceptionsAsRetriable(boolean markDataFetchExceptionsAsRetriable) {
        this.markDataFetchExceptionsAsRetriable = markDataFetchExceptionsAsRetriable;
        return this;
    }

    public boolean isPushdownTopNBrokerQueries() {
        return this.pushdownTopNBrokerQueries;
    }

    @Config(value="pinot.pushdown-topn-broker-queries")
    public PinotConfig setPushdownTopNBrokerQueries(boolean pushdownTopNBrokerQueries) {
        this.pushdownTopNBrokerQueries = pushdownTopNBrokerQueries;
        return this;
    }

    public boolean isPushdownProjectExpressions() {
        return this.pushdownProjectExpressions;
    }

    @Config(value="pinot.pushdown-project-expressions")
    public PinotConfig setPushdownProjectExpressions(boolean pushdownProjectExpressions) {
        this.pushdownProjectExpressions = pushdownProjectExpressions;
        return this;
    }

    public int getStreamingServerGrpcMaxInboundMessageBytes() {
        return this.streamingServerGrpcMaxInboundMessageBytes;
    }

    @Config(value="pinot.streaming-server-grpc-max-inbound-message-bytes")
    public PinotConfig setStreamingServerGrpcMaxInboundMessageBytes(int streamingServerGrpcMaxInboundMessageBytes) {
        this.streamingServerGrpcMaxInboundMessageBytes = streamingServerGrpcMaxInboundMessageBytes;
        return this;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Config(value="pinot.proxy-enabled")
    public PinotConfig setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
        return this;
    }

    public String getGrpcHost() {
        return this.grpcHost;
    }

    @Config(value="pinot.grpc-host")
    public PinotConfig setGrpcHost(String grpcHost) {
        this.grpcHost = grpcHost;
        return this;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    @Config(value="pinot.grpc-port")
    public PinotConfig setGrpcPort(int grpcPort) {
        this.grpcPort = grpcPort;
        return this;
    }

    public boolean isUseSecureConnection() {
        return this.useSecureConnection;
    }

    @Config(value="pinot.secure-connection")
    public PinotConfig setUseSecureConnection(boolean useSecureConnection) {
        this.useSecureConnection = useSecureConnection;
        return this;
    }

    public String getOverrideDistinctCountFunction() {
        return this.overrideDistinctCountFunction;
    }

    @Config(value="pinot.override-distinct-count-function")
    public PinotConfig setOverrideDistinctCountFunction(String overrideDistinctCountFunction) {
        this.overrideDistinctCountFunction = overrideDistinctCountFunction;
        return this;
    }

    public String getGrpcTlsKeyStorePath() {
        return this.grpcTlsKeyStorePath;
    }

    @Config(value="pinot.grpc-tls-key-store-path")
    public PinotConfig setGrpcTlsKeyStorePath(String grpcTlsKeyStorePath) {
        this.grpcTlsKeyStorePath = grpcTlsKeyStorePath;
        return this;
    }

    public String getGrpcTlsKeyStorePassword() {
        return this.grpcTlsKeyStorePassword;
    }

    @Config(value="pinot.grpc-tls-key-store-password")
    public PinotConfig setGrpcTlsKeyStorePassword(String grpcTlsKeyStorePassword) {
        this.grpcTlsKeyStorePassword = grpcTlsKeyStorePassword;
        return this;
    }

    public String getGrpcTlsKeyStoreType() {
        return this.grpcTlsKeyStoreType;
    }

    @Config(value="pinot.grpc-tls-key-store-type")
    public PinotConfig setGrpcTlsKeyStoreType(String grpcTlsKeyStoreType) {
        this.grpcTlsKeyStoreType = grpcTlsKeyStoreType;
        return this;
    }

    public String getGrpcTlsTrustStorePath() {
        return this.grpcTlsTrustStorePath;
    }

    @Config(value="pinot.grpc-tls-trust-store-path")
    public PinotConfig setGrpcTlsTrustStorePath(String grpcTlsTrustStorePath) {
        this.grpcTlsTrustStorePath = grpcTlsTrustStorePath;
        return this;
    }

    public String getGrpcTlsTrustStorePassword() {
        return this.grpcTlsTrustStorePassword;
    }

    @Config(value="pinot.grpc-tls-trust-store-password")
    public PinotConfig setGrpcTlsTrustStorePassword(String grpcTlsTrustStorePassword) {
        this.grpcTlsTrustStorePassword = grpcTlsTrustStorePassword;
        return this;
    }

    public String getGrpcTlsTrustStoreType() {
        return this.grpcTlsTrustStoreType;
    }

    @Config(value="pinot.grpc-tls-trust-store-type")
    public PinotConfig setGrpcTlsTrustStoreType(String grpcTlsTrustStoreType) {
        this.grpcTlsTrustStoreType = grpcTlsTrustStoreType;
        return this;
    }

    @NotNull
    public String getControllerAuthenticationType() {
        return this.controllerAuthenticationType;
    }

    @Config(value="pinot.controller-authentication-type")
    public PinotConfig setControllerAuthenticationType(String controllerAuthenticationType) {
        this.controllerAuthenticationType = controllerAuthenticationType;
        return this;
    }

    public String getControllerAuthenticationUser() {
        return this.controllerAuthenticationUser;
    }

    @Config(value="pinot.controller-authentication-user")
    public PinotConfig setControllerAuthenticationUser(String controllerAuthenticationUser) {
        this.controllerAuthenticationUser = controllerAuthenticationUser;
        return this;
    }

    public String getControllerAuthenticationPassword() {
        return this.controllerAuthenticationPassword;
    }

    @Config(value="pinot.controller-authentication-password")
    @ConfigSecuritySensitive
    public PinotConfig setControllerAuthenticationPassword(String controllerAuthenticationPassword) {
        this.controllerAuthenticationPassword = controllerAuthenticationPassword;
        return this;
    }

    @NotNull
    public String getBrokerAuthenticationType() {
        return this.brokerAuthenticationType;
    }

    @Config(value="pinot.broker-authentication-type")
    public PinotConfig setBrokerAuthenticationType(String brokerAuthenticationType) {
        this.brokerAuthenticationType = brokerAuthenticationType;
        return this;
    }

    public String getBrokerAuthenticationUser() {
        return this.brokerAuthenticationUser;
    }

    @Config(value="pinot.broker-authentication-user")
    public PinotConfig setBrokerAuthenticationUser(String brokerAuthenticationUser) {
        this.brokerAuthenticationUser = brokerAuthenticationUser;
        return this;
    }

    public String getBrokerAuthenticationPassword() {
        return this.brokerAuthenticationPassword;
    }

    @Config(value="pinot.broker-authentication-password")
    @ConfigSecuritySensitive
    public PinotConfig setBrokerAuthenticationPassword(String brokerAuthenticationPassword) {
        this.brokerAuthenticationPassword = brokerAuthenticationPassword;
        return this;
    }

    public String getControllerUrl() {
        List<String> controllerUrls = this.getControllerUrls();
        if (controllerUrls.isEmpty()) {
            throw new PinotException(PinotErrorCode.PINOT_INVALID_CONFIGURATION, Optional.empty(), "No pinot controllers specified");
        }
        return controllerUrls.get(ThreadLocalRandom.current().nextInt(controllerUrls.size()));
    }

    public String getQueryOptions() {
        return this.queryOptions;
    }

    @Config(value="pinot.query-options")
    public PinotConfig setQueryOptions(String options) {
        this.queryOptions = options;
        return this;
    }
}

