/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.pinot.PinotMetadata;
import com.facebook.presto.pinot.PinotNodePartitioningProvider;
import com.facebook.presto.pinot.PinotPageSourceProvider;
import com.facebook.presto.pinot.PinotPlanOptimizer;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.PinotSplitManager;
import com.facebook.presto.pinot.PinotTransactionHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class PinotConnector
implements Connector {
    private static final Logger log = Logger.get(PinotConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final PinotMetadata metadata;
    private final PinotSplitManager splitManager;
    private final PinotPageSourceProvider pageSourceProvider;
    private final PinotNodePartitioningProvider partitioningProvider;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final ConnectorPlanOptimizer planOptimizer;

    @Inject
    public PinotConnector(LifeCycleManager lifeCycleManager, PinotMetadata metadata, PinotSplitManager splitManager, PinotPageSourceProvider pageSourceProvider, PinotNodePartitioningProvider partitioningProvider, PinotSessionProperties pinotSessionProperties, PinotPlanOptimizer planOptimizer) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.partitioningProvider = Objects.requireNonNull(partitioningProvider, "partitioningProvider is null");
        this.sessionProperties = ImmutableList.copyOf(Objects.requireNonNull(pinotSessionProperties, "sessionProperties is null").getSessionProperties());
        this.planOptimizer = Objects.requireNonNull(planOptimizer, "plan optimizer is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return PinotTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.partitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return new ConnectorPlanOptimizerProvider(){

            public Set<ConnectorPlanOptimizer> getLogicalPlanOptimizers() {
                return ImmutableSet.of((Object)PinotConnector.this.planOptimizer);
            }

            public Set<ConnectorPlanOptimizer> getPhysicalPlanOptimizers() {
                return ImmutableSet.of();
            }
        };
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

