/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotColumnMetadata;
import com.facebook.presto.pinot.PinotConnection;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotTable;
import com.facebook.presto.pinot.PinotTableHandle;
import com.facebook.presto.pinot.PinotTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PinotMetadata
implements ConnectorMetadata {
    private final String connectorId;
    private final PinotConnection pinotPrestoConnection;

    @Inject
    public PinotMetadata(ConnectorId connectorId, PinotConnection pinotPrestoConnection) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pinotPrestoConnection = Objects.requireNonNull(pinotPrestoConnection, "pinotPrestoConnection is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)"default");
    }

    private String getPinotTableNameFromPrestoTableName(String prestoTableName) {
        List<String> allTables = this.pinotPrestoConnection.getTableNames();
        for (String pinotTableName : allTables) {
            if (!prestoTableName.equalsIgnoreCase(pinotTableName)) continue;
            return pinotTableName;
        }
        throw new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Unable to find the presto table " + prestoTableName + " in " + allTables);
    }

    public PinotTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        String pinotTableName = this.getPinotTableNameFromPrestoTableName(tableName.getTableName());
        return new PinotTableHandle(this.connectorId, tableName.getSchemaName(), pinotTableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new PinotTableLayoutHandle(pinotTableHandle));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)table;
        Preconditions.checkArgument((boolean)pinotTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        SchemaTableName tableName = new SchemaTableName(pinotTableHandle.getSchemaName(), pinotTableHandle.getTableName());
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String table : this.pinotPrestoConnection.getTableNames()) {
            builder.add((Object)new SchemaTableName("default", table));
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)pinotTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        String pinotTableName = this.getPinotTableNameFromPrestoTableName(pinotTableHandle.getTableName());
        PinotTable table = this.pinotPrestoConnection.getTable(pinotTableName);
        if (table == null) {
            throw new TableNotFoundException(pinotTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName().toLowerCase(Locale.ENGLISH), (Object)new PinotColumnHandle(((PinotColumnMetadata)column).getPinotName(), column.getType(), PinotColumnHandle.PinotColumnType.REGULAR));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        String pinotTableName = this.getPinotTableNameFromPrestoTableName(tableName.getTableName());
        PinotTable table = this.pinotPrestoConnection.getTable(pinotTableName);
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null || prefix.getTableName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((PinotColumnHandle)columnHandle).getColumnMetadata();
    }
}

