/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotBrokerPageSource;
import com.facebook.presto.pinot.PinotClusterInfoFetcher;
import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotSegmentPageSource;
import com.facebook.presto.pinot.PinotSplit;
import com.facebook.presto.pinot.auth.PinotBrokerAuthenticationProvider;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.connector.presto.grpc.PinotStreamingQueryClient;

public class PinotPageSourceProvider
implements ConnectorPageSourceProvider {
    private final String connectorId;
    private final PinotConfig pinotConfig;
    private final PinotStreamingQueryClient pinotStreamingQueryClient;
    private final PinotClusterInfoFetcher clusterInfoFetcher;
    private final ObjectMapper objectMapper;
    private final PinotBrokerAuthenticationProvider brokerAuthenticationProvider;

    @Inject
    public PinotPageSourceProvider(ConnectorId connectorId, PinotConfig pinotConfig, PinotClusterInfoFetcher clusterInfoFetcher, ObjectMapper objectMapper, PinotBrokerAuthenticationProvider brokerAuthenticationProvider) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pinotConfig = Objects.requireNonNull(pinotConfig, "pinotConfig is null");
        this.pinotStreamingQueryClient = new PinotStreamingQueryClient(PinotPageSourceProvider.extractGrpcQueryClientConfig(pinotConfig));
        this.clusterInfoFetcher = Objects.requireNonNull(clusterInfoFetcher, "cluster info fetcher is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "object mapper is null");
        this.brokerAuthenticationProvider = Objects.requireNonNull(brokerAuthenticationProvider, "broker authentication provider is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle tableLayoutHandle, List<ColumnHandle> columns, SplitContext splitContext) {
        Objects.requireNonNull(split, "split is null");
        PinotSplit pinotSplit = (PinotSplit)split;
        Preconditions.checkArgument((boolean)pinotSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        ArrayList<PinotColumnHandle> handles = new ArrayList<PinotColumnHandle>();
        for (ColumnHandle handle : columns) {
            handles.add((PinotColumnHandle)handle);
        }
        switch (pinotSplit.getSplitType()) {
            case SEGMENT: {
                return new PinotSegmentPageSource(session, this.pinotConfig, this.pinotStreamingQueryClient, pinotSplit, handles);
            }
            case BROKER: {
                return new PinotBrokerPageSource(this.pinotConfig, session, pinotSplit.getBrokerPinotQuery().get(), handles, pinotSplit.getExpectedColumnHandles(), this.clusterInfoFetcher, this.objectMapper, this.brokerAuthenticationProvider);
            }
        }
        throw new UnsupportedOperationException("Unknown Pinot split type: " + (Object)((Object)pinotSplit.getSplitType()));
    }

    @VisibleForTesting
    static GrpcConfig extractGrpcQueryClientConfig(PinotConfig config) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        target.put("usePlainText", !config.isUseSecureConnection());
        target.put("maxInboundMessageSizeBytes", config.getStreamingServerGrpcMaxInboundMessageBytes());
        if (config.isUseSecureConnection()) {
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.keystore.path", config.getGrpcTlsKeyStorePath());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.keystore.password", config.getGrpcTlsKeyStorePassword());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.keystore.type", config.getGrpcTlsKeyStoreType());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.truststore.path", config.getGrpcTlsTrustStorePath());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.truststore.password", config.getGrpcTlsTrustStorePassword());
            PinotPageSourceProvider.setOrRemoveProperty(target, "tls.truststore.type", config.getGrpcTlsTrustStoreType());
        }
        return new GrpcConfig(target);
    }

    private static void setOrRemoveProperty(Map<String, Object> prop, String key, Object value) {
        if (value == null) {
            prop.remove(key);
        } else {
            prop.put(key, value);
        }
    }
}

