/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;

public class PinotQueryOptionsUtils {
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator(":");

    private PinotQueryOptionsUtils() {
    }

    public static boolean isNullHandlingEnabled(String queryOptions) {
        if (Strings.isNullOrEmpty((String)queryOptions)) {
            return false;
        }
        ImmutableMap queryOptionsMap = ImmutableMap.copyOf((Map)MAP_SPLITTER.split((CharSequence)queryOptions));
        return Boolean.parseBoolean((String)queryOptionsMap.get("enableNullHandling"));
    }

    public static String getQueryOptionsAsString(String queryOptions) {
        if (Strings.isNullOrEmpty((String)queryOptions)) {
            return "";
        }
        ImmutableMap queryOptionsMap = ImmutableMap.copyOf((Map)MAP_SPLITTER.split((CharSequence)queryOptions));
        if (queryOptionsMap.isEmpty()) {
            return "";
        }
        return queryOptionsMap.entrySet().stream().filter(kv -> !Strings.isNullOrEmpty((String)((String)kv.getKey())) && !Strings.isNullOrEmpty((String)((String)kv.getValue()))).map(kv -> CharMatcher.anyOf((CharSequence)"\"`'").trimFrom((CharSequence)kv.getKey()) + "=" + (String)kv.getValue()).collect(Collectors.joining(",", " option(", ") "));
    }
}

