/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class PinotSessionProperties {
    public static final String FORBID_BROKER_QUERIES = "forbid_broker_queries";
    public static final String ATTEMPT_BROKER_QUERIES = "attempt_broker_queries";
    public static final String RETRY_COUNT = "retry_count";
    public static final String MARK_DATA_FETCH_EXCEPTIONS_AS_RETRIABLE = "mark_data_fetch_exceptions_as_retriable";
    public static final String USE_DATE_TRUNC = "use_date_trunc";
    public static final String NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES = "non_aggregate_limit_for_broker_queries";
    public static final String PUSHDOWN_TOPN_BROKER_QUERIES = "pushdown_topn_broker_queries";
    public static final String PUSHDOWN_PROJECT_EXPRESSIONS = "pushdown_project_expressions";
    public static final String FORBID_SEGMENT_QUERIES = "forbid_segment_queries";
    public static final String NUM_SEGMENTS_PER_SPLIT = "num_segments_per_split";
    public static final String TOPN_LARGE = "topn_large";
    public static final String LIMIT_LARGE_FOR_SEGMENT = "limit_larger_for_segment";
    public static final String OVERRIDE_DISTINCT_COUNT_FUNCTION = "override_distinct_count_function";
    public static final String CONTROLLER_AUTHENTICATION_USER = "controller_authentication_user";
    public static final String CONTROLLER_AUTHENTICATION_PASSWORD = "controller_authentication_password";
    public static final String BROKER_AUTHENTICATION_USER = "broker_authentication_user";
    public static final String BROKER_AUTHENTICATION_PASSWORD = "broker_authentication_password";
    public static final String QUERY_OPTIONS = "query_options";
    private final List<PropertyMetadata<?>> sessionProperties;

    public static int getNumSegmentsPerSplit(ConnectorSession session) {
        int segmentsPerSplit = (Integer)session.getProperty(NUM_SEGMENTS_PER_SPLIT, Integer.class);
        return segmentsPerSplit <= 0 ? Integer.MAX_VALUE : segmentsPerSplit;
    }

    public static boolean isForbidBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_BROKER_QUERIES, Boolean.class);
    }

    public static boolean isForbidSegmentQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(FORBID_SEGMENT_QUERIES, Boolean.class);
    }

    public static boolean isAttemptBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(ATTEMPT_BROKER_QUERIES, Boolean.class);
    }

    public static int getPinotRetryCount(ConnectorSession session) {
        return (Integer)session.getProperty(RETRY_COUNT, Integer.class);
    }

    public static boolean isMarkDataFetchExceptionsAsRetriable(ConnectorSession session) {
        return (Boolean)session.getProperty(MARK_DATA_FETCH_EXCEPTIONS_AS_RETRIABLE, Boolean.class);
    }

    public static boolean isUseDateTruncation(ConnectorSession session) {
        return (Boolean)session.getProperty(USE_DATE_TRUNC, Boolean.class);
    }

    public static int getNonAggregateLimitForBrokerQueries(ConnectorSession session) {
        return (Integer)session.getProperty(NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, Integer.class);
    }

    public static boolean getPushdownTopnBrokerQueries(ConnectorSession session) {
        return (Boolean)session.getProperty(PUSHDOWN_TOPN_BROKER_QUERIES, Boolean.class);
    }

    public static boolean getPushdownProjectExpressions(ConnectorSession session) {
        return (Boolean)session.getProperty(PUSHDOWN_PROJECT_EXPRESSIONS, Boolean.class);
    }

    public static int getTopNLarge(ConnectorSession session) {
        return (Integer)session.getProperty(TOPN_LARGE, Integer.class);
    }

    public static int getLimitLargerForSegment(ConnectorSession session) {
        return (Integer)session.getProperty(LIMIT_LARGE_FOR_SEGMENT, Integer.class);
    }

    public static String getOverrideDistinctCountFunction(ConnectorSession session) {
        return (String)session.getProperty(OVERRIDE_DISTINCT_COUNT_FUNCTION, String.class);
    }

    public static String getControllerAuthenticationUser(ConnectorSession session) {
        return (String)session.getProperty(CONTROLLER_AUTHENTICATION_USER, String.class);
    }

    public static String getControllerAuthenticationPassword(ConnectorSession session) {
        return (String)session.getProperty(CONTROLLER_AUTHENTICATION_PASSWORD, String.class);
    }

    public static String getBrokerAuthenticationUser(ConnectorSession session) {
        return (String)session.getProperty(BROKER_AUTHENTICATION_USER, String.class);
    }

    public static String getBrokerAuthenticationPassword(ConnectorSession session) {
        return (String)session.getProperty(BROKER_AUTHENTICATION_PASSWORD, String.class);
    }

    public static String getQueryOptions(ConnectorSession session) {
        return (String)session.getProperty(QUERY_OPTIONS, String.class);
    }

    @Inject
    public PinotSessionProperties(PinotConfig pinotConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)FORBID_BROKER_QUERIES, (String)"Forbid queries to the broker", (Boolean)pinotConfig.isForbidBrokerQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)FORBID_SEGMENT_QUERIES, (String)"Forbid segment queries", (Boolean)pinotConfig.isForbidSegmentQueries(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)ATTEMPT_BROKER_QUERIES, (String)"Attempt broker queries", (Boolean)pinotConfig.isAttemptBrokerQueries(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)RETRY_COUNT, (String)"Retry count for retriable pinot data fetch calls", (Integer)pinotConfig.getFetchRetryCount(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)MARK_DATA_FETCH_EXCEPTIONS_AS_RETRIABLE, (String)"Retry Pinot query on data fetch exceptions", (Boolean)pinotConfig.isMarkDataFetchExceptionsAsRetriable(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)NON_AGGREGATE_LIMIT_FOR_BROKER_QUERIES, (String)"Max limit for non aggregate queries to the pinot broker", (Integer)pinotConfig.getNonAggregateLimitForBrokerQueries(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)LIMIT_LARGE_FOR_SEGMENT, (String)"Server query selection limit for large segment", (Integer)pinotConfig.getLimitLargeForSegment(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)TOPN_LARGE, (String)"Broker query group by limit", (Integer)pinotConfig.getTopNLarge(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)OVERRIDE_DISTINCT_COUNT_FUNCTION, (String)"Override distinct count function to another function name", (String)pinotConfig.getOverrideDistinctCountFunction(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)CONTROLLER_AUTHENTICATION_USER, (String)"Controller authentication user", (String)pinotConfig.getControllerAuthenticationUser(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)CONTROLLER_AUTHENTICATION_PASSWORD, (String)"Controller authentication password", (String)pinotConfig.getControllerAuthenticationPassword(), (boolean)false), (Object)PropertyMetadata.stringProperty((String)BROKER_AUTHENTICATION_USER, (String)"Broker authentication user", (String)pinotConfig.getBrokerAuthenticationUser(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.stringProperty((String)BROKER_AUTHENTICATION_PASSWORD, (String)"Broker authentication password", (String)pinotConfig.getBrokerAuthenticationPassword(), (boolean)false), PropertyMetadata.stringProperty((String)QUERY_OPTIONS, (String)"Query Options, in the format of k1:v1,k2:v2", (String)pinotConfig.getQueryOptions(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_DATE_TRUNC, (String)"Use the new UDF dateTrunc in pinot that is more presto compatible", (Boolean)pinotConfig.isUseDateTrunc(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSHDOWN_TOPN_BROKER_QUERIES, (String)"Push down order by to pinot broker for top queries", (Boolean)pinotConfig.isPushdownTopNBrokerQueries(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSHDOWN_PROJECT_EXPRESSIONS, (String)"Push down expressions in projection to Pinot broker", (Boolean)pinotConfig.isPushdownProjectExpressions(), (boolean)false), new PropertyMetadata(NUM_SEGMENTS_PER_SPLIT, "Number of segments of the same host per split", (Type)IntegerType.INTEGER, Integer.class, (Object)pinotConfig.getNumSegmentsPerSplit(), false, value -> {
            int ret = ((Number)value).intValue();
            Preconditions.checkArgument((ret > 0 ? 1 : 0) != 0, (Object)"Number of segments per split must be more than zero");
            return ret;
        }, object -> object)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

