/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PinotSplit
implements ConnectorSplit {
    private final String connectorId;
    private final SplitType splitType;
    private final List<PinotColumnHandle> expectedColumnHandles;
    private final Optional<PinotQueryGenerator.GeneratedPinotQuery> brokerPinotQuery;
    private final Optional<String> segmentPinotQuery;
    private final List<String> segments;
    private final Optional<String> segmentHost;
    private final Optional<Integer> grpcPort;

    @JsonCreator
    public PinotSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="splitType") SplitType splitType, @JsonProperty(value="expectedColumnHandles") List<PinotColumnHandle> expectedColumnHandles, @JsonProperty(value="brokerQuery") Optional<PinotQueryGenerator.GeneratedPinotQuery> brokerPinotQuery, @JsonProperty(value="segmentPinotQuery") Optional<String> segmentPinotQuery, @JsonProperty(value="segments") List<String> segments, @JsonProperty(value="segmentHost") Optional<String> segmentHost, @JsonProperty(value="grpcPort") Optional<Integer> grpcPort) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.splitType = Objects.requireNonNull(splitType, "splitType id is null");
        this.expectedColumnHandles = Objects.requireNonNull(expectedColumnHandles, "expected column handles is null");
        this.brokerPinotQuery = Objects.requireNonNull(brokerPinotQuery, "brokerPinotQuery is null");
        this.segmentPinotQuery = Objects.requireNonNull(segmentPinotQuery, "segmentPinotQuery is null");
        this.segments = ImmutableList.copyOf((Collection)Objects.requireNonNull(segments, "segment is null"));
        this.segmentHost = Objects.requireNonNull(segmentHost, "host is null");
        this.grpcPort = grpcPort;
        if (splitType == SplitType.SEGMENT) {
            Preconditions.checkArgument((boolean)segmentPinotQuery.isPresent(), (Object)"segmentPinotQuery is missing from the split");
            Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Segments are missing from the split");
            Preconditions.checkArgument((boolean)segmentHost.isPresent(), (Object)"Segment host address is missing from the split");
        } else {
            Preconditions.checkArgument((boolean)brokerPinotQuery.isPresent(), (Object)"brokerPinotQuery is missing from the split");
        }
    }

    public static PinotSplit createBrokerSplit(String connectorId, List<PinotColumnHandle> expectedColumnHandles, PinotQueryGenerator.GeneratedPinotQuery brokerQuery) {
        return new PinotSplit(Objects.requireNonNull(connectorId, "connector id is null"), SplitType.BROKER, expectedColumnHandles, Optional.of(Objects.requireNonNull(brokerQuery, "brokerQuery is null")), Optional.empty(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty());
    }

    public static PinotSplit createSegmentSplit(String connectorId, String segmentPinotQuery, List<PinotColumnHandle> expectedColumnHandles, List<String> segments, String segmentHost, int grpcPort) {
        return new PinotSplit(Objects.requireNonNull(connectorId, "connector id is null"), SplitType.SEGMENT, expectedColumnHandles, Optional.empty(), Optional.of(Objects.requireNonNull(segmentPinotQuery, "segmentPinotQuery is null")), Objects.requireNonNull(segments, "segments are null"), Optional.of(Objects.requireNonNull(segmentHost, "segmentHost is null")), Optional.of(grpcPort));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public SplitType getSplitType() {
        return this.splitType;
    }

    @JsonProperty
    public Optional<PinotQueryGenerator.GeneratedPinotQuery> getBrokerPinotQuery() {
        return this.brokerPinotQuery;
    }

    @JsonProperty
    public Optional<String> getSegmentPinotQuery() {
        return this.segmentPinotQuery;
    }

    @JsonProperty
    public Optional<String> getSegmentHost() {
        return this.segmentHost;
    }

    @JsonProperty
    public List<String> getSegments() {
        return this.segments;
    }

    public Optional<String> getGrpcHost() {
        if (this.segmentHost.isPresent()) {
            String[] hostSplits = this.segmentHost.get().split("_");
            return hostSplits.length > 1 ? Optional.of(hostSplits[hostSplits.length - 2]) : this.segmentHost;
        }
        return Optional.empty();
    }

    @JsonProperty
    public Optional<Integer> getGrpcPort() {
        return this.grpcPort;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("splitType", (Object)this.splitType).add("columnHandle", this.expectedColumnHandles).add("segmentPinotQuery", this.segmentPinotQuery).add("brokerPinotQuery", this.brokerPinotQuery).add("segments", this.segments).add("segmentHost", this.segmentHost).toString();
    }

    @JsonProperty
    public List<PinotColumnHandle> getExpectedColumnHandles() {
        return this.expectedColumnHandles;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public static enum SplitType {
        SEGMENT,
        BROKER;

    }
}

