/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotColumnHandle;
import com.facebook.presto.pinot.query.PinotQueryGenerator;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class PinotTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final Optional<Boolean> forBroker;
    private final Optional<PinotQueryGenerator.GeneratedPinotQuery> pinotQuery;
    private final Optional<List<PinotColumnHandle>> expectedColumnHandles;

    public PinotTableHandle(String connectorId, String schemaName, String tableName) {
        this(connectorId, schemaName, tableName, Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonCreator
    public PinotTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="forBroker") Optional<Boolean> forBroker, @JsonProperty(value="expectedColumnHandles") Optional<List<PinotColumnHandle>> expectedColumnHandles, @JsonProperty(value="pinotQuery") Optional<PinotQueryGenerator.GeneratedPinotQuery> pinotQuery) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.forBroker = Objects.requireNonNull(forBroker, "safe to execute is null");
        this.pinotQuery = Objects.requireNonNull(pinotQuery, "broker pinotQuery is null");
        this.expectedColumnHandles = Objects.requireNonNull(expectedColumnHandles, "expected column handles is null");
    }

    @JsonProperty
    public Optional<PinotQueryGenerator.GeneratedPinotQuery> getPinotQuery() {
        return this.pinotQuery;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<Boolean> getForBroker() {
        return this.forBroker;
    }

    @JsonProperty
    public Optional<List<PinotColumnHandle>> getExpectedColumnHandles() {
        return this.expectedColumnHandles;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotTableHandle that = (PinotTableHandle)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.forBroker, that.forBroker) && Objects.equals(this.expectedColumnHandles, that.expectedColumnHandles) && Objects.equals(this.pinotQuery, that.pinotQuery);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaName, this.tableName, this.forBroker, this.expectedColumnHandles, this.pinotQuery);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("forBroker", this.forBroker).add("expectedColumnHandles", this.expectedColumnHandles).add("pinotQuery", this.pinotQuery).toString();
    }
}

