/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot;

import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import org.apache.pinot.spi.utils.TimestampUtils;

public class PinotUtils {
    private static final String PINOT_INFINITY = "\u221e";
    private static final String PINOT_POSITIVE_INFINITY = "+\u221e";
    private static final String PINOT_NEGATIVE_INFINITY = "-\u221e";
    private static final Double PRESTO_INFINITY = Double.POSITIVE_INFINITY;
    private static final Double PRESTO_NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;

    private PinotUtils() {
    }

    static boolean isValidPinotHttpResponseCode(int status) {
        return status >= 200 && status < 300;
    }

    public static <T> T doWithRetries(int retries, Function<Integer, T> caller) {
        PinotException firstError = null;
        Preconditions.checkState((retries > 0 ? 1 : 0) != 0, (String)"Invalid num of retries %d", (int)retries);
        for (int i = 0; i < retries; ++i) {
            try {
                return caller.apply(i);
            }
            catch (PinotException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (e.getPinotErrorCode().isRetriable()) continue;
                throw e;
            }
        }
        throw firstError;
    }

    public static long parseTimestamp(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            try {
                return PinotUtils.parseDouble(value).longValue();
            }
            catch (Exception ignoredEx) {
                return TimestampUtils.toMillisSinceEpoch((String)value);
            }
        }
    }

    public static Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ne) {
            switch (value) {
                case "\u221e": 
                case "+\u221e": {
                    return PRESTO_INFINITY;
                }
                case "-\u221e": {
                    return PRESTO_NEGATIVE_INFINITY;
                }
            }
            throw new PinotException(PinotErrorCode.PINOT_DECODE_ERROR, Optional.empty(), "Cannot decode double value from pinot " + value, ne);
        }
    }
}

