/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.auth;

import com.facebook.presto.pinot.PinotConfig;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.auth.PinotAuthenticationProvider;
import com.facebook.presto.pinot.auth.none.PinotEmptyAuthenticationProvider;
import com.facebook.presto.pinot.auth.password.PinotPasswordAuthenticationProvider;
import com.facebook.presto.spi.ConnectorSession;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class PinotControllerAuthenticationProvider
implements PinotAuthenticationProvider {
    private final PinotAuthenticationProvider delegate;

    @Inject
    public PinotControllerAuthenticationProvider(PinotConfig pinotConfig) {
        String type;
        switch (type = pinotConfig.getControllerAuthenticationType()) {
            case "NONE": {
                this.delegate = PinotEmptyAuthenticationProvider.instance();
                break;
            }
            case "PASSWORD": {
                try {
                    this.delegate = new PinotPasswordAuthenticationProvider(pinotConfig.getControllerAuthenticationUser(), pinotConfig.getControllerAuthenticationPassword(), PinotSessionProperties.class.getMethod("getControllerAuthenticationUser", ConnectorSession.class), PinotSessionProperties.class.getMethod("getControllerAuthenticationPassword", ConnectorSession.class));
                    break;
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Failed to create Controller auth provider", e);
                }
            }
            default: {
                throw new RuntimeException("Unknown authentication type - " + type);
            }
        }
    }

    private PinotControllerAuthenticationProvider(PinotAuthenticationProvider delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Delegate controller authentication provider is required");
    }

    @Override
    public Optional<String> getAuthenticationToken() {
        return this.delegate.getAuthenticationToken();
    }

    @Override
    public Optional<String> getAuthenticationToken(ConnectorSession session) {
        return this.delegate.getAuthenticationToken(session);
    }

    public static PinotControllerAuthenticationProvider create(PinotAuthenticationProvider delegate) {
        return new PinotControllerAuthenticationProvider(delegate);
    }
}

