/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.auth.password;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.pinot.PinotSessionProperties;
import com.facebook.presto.pinot.auth.PinotAuthenticationProvider;
import com.facebook.presto.spi.ConnectorSession;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;

public class PinotPasswordAuthenticationProvider
implements PinotAuthenticationProvider {
    private static final Logger log = Logger.get(PinotPasswordAuthenticationProvider.class);
    private final Optional<String> authToken;
    private final Method getAuthenticationUserMethod;
    private final Method getAuthenticationPasswordMethod;

    public PinotPasswordAuthenticationProvider(String user, String password, Method getControllerAuthenticationUser, Method getControllerAuthenticationPassword) {
        Objects.requireNonNull(user, "user is null");
        Objects.requireNonNull(password, "password is null");
        this.authToken = Optional.of(this.encode(user, password));
        this.getAuthenticationUserMethod = getControllerAuthenticationUser;
        this.getAuthenticationPasswordMethod = getControllerAuthenticationPassword;
    }

    @Override
    public Optional<String> getAuthenticationToken() {
        return this.authToken;
    }

    @Override
    public Optional<String> getAuthenticationToken(ConnectorSession connectorSession) {
        if (connectorSession != null) {
            try {
                String user = (String)this.getAuthenticationUserMethod.invoke(PinotSessionProperties.class, connectorSession);
                String password = (String)this.getAuthenticationPasswordMethod.invoke(PinotSessionProperties.class, connectorSession);
                return Optional.of(this.encode(user, password));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("Failed to extract auth from session configs, use empty auth");
                return Optional.empty();
            }
        }
        return this.authToken;
    }

    private String encode(String username, String password) {
        String valueToEncode = username + ":" + password;
        return Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }
}

