/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.query;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.pinot.PinotErrorCode;
import com.facebook.presto.pinot.PinotException;
import com.facebook.presto.pinot.PinotPushdownUtils;
import com.facebook.presto.pinot.query.PinotExpression;
import com.facebook.presto.pinot.query.PinotQueryGeneratorContext;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PinotFilterExpressionConverter
implements RowExpressionVisitor<PinotExpression, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection>> {
    private static final Set<String> LOGICAL_BINARY_OPS_FILTER = ImmutableSet.of((Object)"=", (Object)"<", (Object)"<=", (Object)">", (Object)">=", (Object)"<>", (Object[])new String[0]);
    private final TypeManager typeManager;
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;

    public PinotFilterExpressionConverter(TypeManager typeManager, FunctionMetadataManager functionMetadataManager, StandardFunctionResolution standardFunctionResolution) {
        this.typeManager = Objects.requireNonNull(typeManager, "type manager is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "function metadata manager is null");
        this.standardFunctionResolution = Objects.requireNonNull(standardFunctionResolution, "standardFunctionResolution is null");
    }

    private PinotExpression handleIn(SpecialFormExpression specialForm, boolean isWhitelist, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return PinotExpression.derived(String.format("(%s %s (%s))", ((PinotExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), isWhitelist ? "IN" : "NOT IN", specialForm.getArguments().subList(1, specialForm.getArguments().size()).stream().map(argument -> ((PinotExpression)argument.accept((RowExpressionVisitor)this, (Object)context)).getDefinition()).collect(Collectors.joining(", "))));
    }

    private PinotExpression handleIsNull(SpecialFormExpression specialForm, boolean isWhitelist, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return PinotExpression.derived(String.format("(%s %s)", ((PinotExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), isWhitelist ? "IS NULL" : "IS NOT NULL"));
    }

    private PinotExpression handleLogicalBinary(String operator, CallExpression call, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (!LOGICAL_BINARY_OPS_FILTER.contains(operator)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("'%s' is not supported in filter", operator));
        }
        List arguments = call.getArguments();
        if (arguments.size() == 2) {
            return this.handleDateOrTimestampBinaryExpression(operator, arguments, context).orElseGet(() -> PinotExpression.derived(String.format("(%s %s %s)", ((PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, (Object)context)).getDefinition(), operator, ((PinotExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, (Object)context)).getDefinition())));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Unknown logical binary: '%s'", call));
    }

    private Optional<PinotExpression> handleDateOrTimestampBinaryExpression(String operator, List<RowExpression> arguments, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        Optional<String> left = this.handleTimeValueCast(context, arguments.get(1), arguments.get(0));
        Optional<String> right = this.handleTimeValueCast(context, arguments.get(0), arguments.get(1));
        if (left.isPresent() && right.isPresent()) {
            return Optional.of(PinotExpression.derived(String.format("(%s %s %s)", left.get(), operator, right.get())));
        }
        return Optional.empty();
    }

    private static boolean isDateTimeConstantType(Type type) {
        return type == DateType.DATE || type == TimestampType.TIMESTAMP || type == TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
    }

    private Optional<String> handleTimeValueCast(Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context, RowExpression timeFieldExpression, RowExpression timeValueExpression) {
        Type expectedType;
        Type inputType;
        if (!PinotFilterExpressionConverter.isDateTimeConstantType(timeFieldExpression.getType()) || !PinotFilterExpressionConverter.isDateTimeConstantType(timeValueExpression.getType())) {
            return Optional.empty();
        }
        String timeValueString = ((PinotExpression)timeValueExpression.accept((RowExpressionVisitor)this, context)).getDefinition();
        if (timeFieldExpression instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)timeFieldExpression;
            if (!this.standardFunctionResolution.isCastFunction(callExpression.getFunctionHandle())) {
                return Optional.empty();
            }
            if (callExpression.getArguments().size() != 1) {
                return Optional.empty();
            }
            inputType = ((RowExpression)callExpression.getArguments().get(0)).getType();
            expectedType = callExpression.getType();
        } else if (timeFieldExpression instanceof VariableReferenceExpression) {
            inputType = timeFieldExpression.getType();
            expectedType = timeValueExpression.getType();
        } else {
            if (timeFieldExpression instanceof ConstantExpression) {
                return Optional.of(timeValueString);
            }
            return Optional.empty();
        }
        if (inputType == DateType.DATE && (expectedType == TimestampType.TIMESTAMP || expectedType == TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            try {
                return Optional.of(Long.toString(TimeUnit.MILLISECONDS.toDays(Long.parseLong(timeValueString))));
            }
            catch (NumberFormatException e) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Unable to parse timestamp string: '%s'", timeValueString), e);
            }
        }
        if ((inputType == TimestampType.TIMESTAMP || inputType == TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) && expectedType == DateType.DATE) {
            try {
                return Optional.of(Long.toString(TimeUnit.DAYS.toMillis(Long.parseLong(timeValueString))));
            }
            catch (NumberFormatException e) {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Unable to parse date string: '%s'", timeValueString), e);
            }
        }
        return Optional.of(timeValueString);
    }

    private PinotExpression handleContains(CallExpression contains, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (contains.getArguments().size() != 2) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Contains operator not supported: %s", contains));
        }
        RowExpression left = (RowExpression)contains.getArguments().get(0);
        RowExpression right = (RowExpression)contains.getArguments().get(1);
        if (!(right instanceof ConstantExpression)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Contains operator can not push down non-literal value: %s", right));
        }
        return PinotExpression.derived(String.format("(%s = %s)", ((PinotExpression)left.accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)right.accept((RowExpressionVisitor)this, context)).getDefinition()));
    }

    private PinotExpression handleBetween(CallExpression between, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (between.getArguments().size() == 3) {
            RowExpression value = (RowExpression)between.getArguments().get(0);
            RowExpression min = (RowExpression)between.getArguments().get(1);
            RowExpression max = (RowExpression)between.getArguments().get(2);
            return PinotExpression.derived(String.format("(%s BETWEEN %s AND %s)", ((PinotExpression)value.accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)min.accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)max.accept((RowExpressionVisitor)this, context)).getDefinition()));
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Between operator not supported: %s", between));
    }

    private PinotExpression handleNot(CallExpression not, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        RowExpression input;
        if (not.getArguments().size() == 1 && (input = (RowExpression)not.getArguments().get(0)) instanceof SpecialFormExpression) {
            SpecialFormExpression specialFormExpression = (SpecialFormExpression)input;
            if (specialFormExpression.getForm() == SpecialFormExpression.Form.IN) {
                return this.handleIn(specialFormExpression, false, context);
            }
            if (specialFormExpression.getForm() == SpecialFormExpression.Form.IS_NULL) {
                return this.handleIsNull(specialFormExpression, false, context);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("NOT operator is supported only on top of IN and IS_NULL operator. Received: %s", not));
    }

    private PinotExpression handleCast(CallExpression cast, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (cast.getArguments().size() == 1) {
            RowExpression input = (RowExpression)cast.getArguments().get(0);
            Type expectedType = cast.getType();
            if (this.typeManager.canCoerce(input.getType(), expectedType)) {
                return (PinotExpression)input.accept((RowExpressionVisitor)this, context);
            }
            if (expectedType == DateType.DATE) {
                try {
                    PinotExpression expression = (PinotExpression)input.accept((RowExpressionVisitor)this, context);
                    if (input.getType() == TimestampType.TIMESTAMP || input.getType() == TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) {
                        return expression;
                    }
                    if (input.getType() == VarcharType.VARCHAR) {
                        String date = expression.getDefinition().substring(1, expression.getDefinition().length() - 1);
                        Integer daysSinceEpoch = (int)LocalDate.parse(date).toEpochDay();
                        return new PinotExpression(daysSinceEpoch.toString(), expression.getOrigin());
                    }
                }
                catch (Exception e) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Cast date value expression is not supported: " + cast);
                }
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Non implicit casts not supported: " + cast);
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("This type of CAST operator not supported. Received: %s", cast));
    }

    private PinotExpression handleCoalesce(SpecialFormExpression coalesce, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        int numArguments = coalesce.getArguments().size();
        return PinotExpression.derived(String.format("CASE TRUE %s ELSE %s END", coalesce.getArguments().subList(0, numArguments - 1).stream().map(argument -> {
            String expression = this.getExpressionOrConstantString((RowExpression)argument, context);
            while (argument instanceof CallExpression) {
                if (((CallExpression)argument).getArguments().size() != 1) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Coalesce operator not supported: %s", coalesce));
                }
                argument = (RowExpression)((CallExpression)argument).getArguments().get(0);
            }
            if (argument instanceof VariableReferenceExpression) {
                if (PinotQueryGeneratorContext.Origin.TABLE_COLUMN != ((PinotQueryGeneratorContext.Selection)context.apply((VariableReferenceExpression)argument)).getOrigin()) {
                    throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Coalesce operator can not push down non-table column: %s", argument));
                }
            } else {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("Coalesce operator does not support: %s", argument));
            }
            return String.format("WHEN %s IS NOT NULL THEN %s", this.getExpressionOrConstantString((RowExpression)argument, context), expression);
        }).collect(Collectors.joining(" ")), this.getExpressionOrConstantString((RowExpression)coalesce.getArguments().get(numArguments - 1), context)));
    }

    private PinotExpression handleFunction(CallExpression function, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        String functionName = function.getDisplayName().toLowerCase(Locale.ENGLISH);
        List arguments = function.getArguments();
        switch (functionName) {
            case "lower": 
            case "trim": {
                return PinotExpression.derived(String.format("%s(%s)", functionName, ((PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition()));
            }
            case "concat": {
                int numArguments = arguments.size();
                return PinotExpression.derived(String.format("%s%s%s", Strings.repeat((String)String.format("%s(", functionName), (int)(numArguments - 1)), this.getExpressionOrConstantString((RowExpression)function.getArguments().get(0), context), arguments.subList(1, numArguments).stream().map(argument -> String.format(", %s, '')", this.getExpressionOrConstantString((RowExpression)argument, context))).collect(Collectors.joining(""))));
            }
            case "strpos": {
                if (arguments.size() == 2) {
                    return PinotExpression.derived(String.format("%s(%s,%s) + 1", functionName, ((PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context)).getDefinition()));
                }
                return PinotExpression.derived(String.format("%s(%s,%s,%s) + 1", functionName, ((PinotExpression)((RowExpression)arguments.get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)((RowExpression)arguments.get(1)).accept((RowExpressionVisitor)this, context)).getDefinition(), ((PinotExpression)((RowExpression)arguments.get(2)).accept((RowExpressionVisitor)this, context)).getDefinition()));
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("function %s not supported in filter yet", function.getDisplayName()));
    }

    public PinotExpression visitCall(CallExpression call, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        FunctionHandle functionHandle = call.getFunctionHandle();
        if (this.standardFunctionResolution.isNotFunction(functionHandle)) {
            return this.handleNot(call, context);
        }
        if (this.standardFunctionResolution.isCastFunction(functionHandle)) {
            return this.handleCast(call, context);
        }
        if (this.standardFunctionResolution.isBetweenFunction(functionHandle)) {
            return this.handleBetween(call, context);
        }
        if (this.standardFunctionResolution.isArithmeticFunction(functionHandle)) {
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Arithmetic expressions are not supported in filter: " + call);
        }
        FunctionMetadata functionMetadata = this.functionMetadataManager.getFunctionMetadata(call.getFunctionHandle());
        Optional operatorType = functionMetadata.getOperatorType();
        if (this.standardFunctionResolution.isComparisonFunction(functionHandle) && operatorType.isPresent()) {
            return this.handleLogicalBinary(((OperatorType)operatorType.get()).getOperator(), call, context);
        }
        if ("contains".equals(functionMetadata.getName().getObjectName())) {
            return this.handleContains(call, context);
        }
        if (functionMetadata.getName().getObjectName().equalsIgnoreCase("$literal$timestamp") || functionMetadata.getName().getObjectName().equalsIgnoreCase("$literal$date")) {
            return this.handleDateAndTimestampMagicLiteralFunction(call, context);
        }
        return this.handleFunction(call, context);
    }

    private PinotExpression handleDateAndTimestampMagicLiteralFunction(CallExpression timestamp, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (timestamp.getArguments().size() == 1) {
            RowExpression input = (RowExpression)timestamp.getArguments().get(0);
            Type expectedType = timestamp.getType();
            if (this.typeManager.canCoerce(input.getType(), expectedType) || input.getType() == BigintType.BIGINT || input.getType() == IntegerType.INTEGER) {
                return (PinotExpression)input.accept((RowExpressionVisitor)this, context);
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Non implicit Date/Timestamp Literal is not supported: " + timestamp);
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), String.format("The Date/Timestamp Literal is not supported. Received: %s", timestamp));
    }

    public PinotExpression visitInputReference(InputReferenceExpression reference, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support struct dereferencing " + reference);
    }

    public PinotExpression visitConstant(ConstantExpression literal, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        return new PinotExpression(PinotPushdownUtils.getLiteralAsString(literal), PinotQueryGeneratorContext.Origin.LITERAL);
    }

    public PinotExpression visitLambda(LambdaDefinitionExpression lambda, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support lambda " + lambda);
    }

    public PinotExpression visitVariableReference(VariableReferenceExpression reference, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        PinotQueryGeneratorContext.Selection input = Objects.requireNonNull(context.apply(reference), String.format("Input column %s does not exist in the input: %s", reference, context));
        return new PinotExpression(input.getDefinition(), input.getOrigin());
    }

    private String getExpressionOrConstantString(RowExpression expression, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        if (expression instanceof ConstantExpression) {
            return new PinotExpression(PinotPushdownUtils.getLiteralAsString((ConstantExpression)expression), PinotQueryGeneratorContext.Origin.LITERAL).getDefinition();
        }
        return ((PinotExpression)expression.accept((RowExpressionVisitor)this, context)).getDefinition();
    }

    public PinotExpression visitSpecialForm(SpecialFormExpression specialForm, Function<VariableReferenceExpression, PinotQueryGeneratorContext.Selection> context) {
        switch (specialForm.getForm()) {
            case NULL_IF: 
            case DEREFERENCE: 
            case ROW_CONSTRUCTOR: 
            case BIND: {
                throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Pinot does not support the special form " + specialForm);
            }
            case SWITCH: {
                int numArguments = specialForm.getArguments().size();
                String searchExpression = this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(0), context);
                return PinotExpression.derived(String.format("CASE %s %s ELSE %s END", searchExpression, specialForm.getArguments().subList(1, numArguments - 1).stream().map(argument -> ((PinotExpression)argument.accept((RowExpressionVisitor)this, (Object)context)).getDefinition()).collect(Collectors.joining(" ")), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(numArguments - 1), context)));
            }
            case WHEN: {
                return PinotExpression.derived(String.format("%s %s THEN %s", specialForm.getForm().toString(), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(0), context), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(1), context)));
            }
            case IF: {
                return PinotExpression.derived(String.format("CASE TRUE WHEN %s THEN %s ELSE %s END", this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(0), context), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(1), context), this.getExpressionOrConstantString((RowExpression)specialForm.getArguments().get(2), context)));
            }
            case COALESCE: {
                return this.handleCoalesce(specialForm, context);
            }
            case IN: {
                return this.handleIn(specialForm, true, context);
            }
            case AND: 
            case OR: {
                return PinotExpression.derived(String.format("(%s %s %s)", ((PinotExpression)((RowExpression)specialForm.getArguments().get(0)).accept((RowExpressionVisitor)this, context)).getDefinition(), specialForm.getForm().toString(), ((PinotExpression)((RowExpression)specialForm.getArguments().get(1)).accept((RowExpressionVisitor)this, context)).getDefinition()));
            }
            case IS_NULL: {
                return this.handleIsNull(specialForm, true, context);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_EXPRESSION, Optional.empty(), "Unexpected special form: " + specialForm);
    }
}

